/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.resources.LazySet;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.logging.Logging;

public final class Converters {
    private static final Logger LOGGER = Logging.getLogger(Converters.class);
    static ConverterFactory[] factories;
    private static FactoryRegistry registry;

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(Converters.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(ConverterFactory.class));
        }
        return registry;
    }

    public static synchronized Set<ConverterFactory> getConverterFactories(Hints hints) {
        hints = GeoTools.addDefaultHints((Hints)hints);
        return new LazySet(Converters.getServiceRegistry().getFactories(ConverterFactory.class, null, hints));
    }

    public static Set<ConverterFactory> getConverterFactories(Class<?> source, Class<?> target) {
        HashSet<ConverterFactory> factories = new HashSet<ConverterFactory>();
        for (ConverterFactory factory : Converters.factories()) {
            if (factory.createConverter(source, target, null) == null) continue;
            factories.add(factory);
        }
        return factories;
    }

    public static <T> T convert(Object source, Class<T> target) {
        return Converters.convert(source, target, null);
    }

    public static <T> T convert(Object source, Class<T> target, Hints hints) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = source.getClass();
        if (sourceClass == target || sourceClass.equals(target) || target.isAssignableFrom(sourceClass)) {
            return target.cast(source);
        }
        for (ConverterFactory factory : Converters.factories()) {
            Converter converter = factory.createConverter(sourceClass, target, hints);
            if (converter == null) continue;
            try {
                T converted = converter.convert(source, target);
                if (converted == null) continue;
                return converted;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Error applying the converter " + converter.getClass() + " on (" + source + "," + target + ")", e);
            }
        }
        if (String.class.equals(target)) {
            return target.cast(source.toString());
        }
        return null;
    }

    static ConverterFactory[] factories() {
        if (factories == null) {
            Set<ConverterFactory> factoryCollection = Converters.getConverterFactories(GeoTools.getDefaultHints());
            factories = factoryCollection.toArray(new ConverterFactory[factoryCollection.size()]);
        }
        return factories;
    }
}

