/*
 * Decompiled with CFR 0.152.
 */
package asposewobfuscated;

import asposewobfuscated.zzK2;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.lang.ref.WeakReference;

public abstract class zzMS
implements PaintContext {
    private static WeakReference<Raster> cached;
    private static ColorModel cachedModel;
    private static final int[] zzDb;
    private static final int[] zzDa;
    protected int zzD9;
    protected int zzD8;
    private ColorModel model;
    private int zzDf;
    private int zzDg;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    private boolean isSimpleLookup;
    private int zzD7;
    private float[] normalizedIntervals;
    private float[] fractions;
    private int[] gradient;
    private int[][] zzD6;
    private final ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private int fastGradientArraySize;
    private Raster saved;

    public zzMS(Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float[] fArray, Color[] colorArray, int n, int n2) {
        AffineTransform affineTransform2;
        if (rectangle == null) {
            throw new NullPointerException("Device bounds cannot be null");
        }
        if (rectangle2D == null) {
            throw new NullPointerException("User bounds cannot be null");
        }
        if (affineTransform == null) {
            throw new NullPointerException("Transform cannot be null");
        }
        if (renderingHints == null) {
            throw new NullPointerException("RenderingHints cannot be null");
        }
        this.zzD9 = rectangle.x;
        this.zzD8 = rectangle.y;
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (Exception exception) {
            affineTransform2 = new AffineTransform();
        }
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this.a00 = (float)dArray[0];
        this.a10 = (float)dArray[1];
        this.a01 = (float)dArray[2];
        this.a11 = (float)dArray[3];
        this.a02 = (float)dArray[4];
        this.a12 = (float)dArray[5];
        this.zzDg = n;
        this.zzDf = n2;
        this.fractions = fArray;
        this.zzZ(colorArray);
    }

    private void zzZ(Color[] colorArray) {
        int n;
        int n2;
        Color[] colorArray2;
        if (this.zzDf == zzK2.zzZ.zzzx) {
            colorArray2 = new Color[colorArray.length];
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                n = colorArray[n2].getRGB();
                int n3 = n >>> 24;
                int n4 = zzDb[n >> 16 & 0xFF];
                int n5 = zzDb[n >> 8 & 0xFF];
                int n6 = zzDb[n & 0xFF];
                colorArray2[n2] = new Color(n4, n5, n6, n3);
            }
        } else {
            colorArray2 = colorArray;
        }
        this.normalizedIntervals = new float[this.fractions.length - 1];
        for (n2 = 0; n2 < this.normalizedIntervals.length; ++n2) {
            this.normalizedIntervals[n2] = this.fractions[n2 + 1] - this.fractions[n2];
        }
        this.zzD7 = -16777216;
        this.zzD6 = new int[this.normalizedIntervals.length][];
        float f = 1.0f;
        for (n = 0; n < this.normalizedIntervals.length; ++n) {
            if (this.normalizedIntervals[n] == 0.0f || !(this.normalizedIntervals[n] < f)) continue;
            f = this.normalizedIntervals[n];
        }
        n = (int)(256.0f / f);
        if (n > 5000) {
            this.zzY(colorArray2);
        } else {
            this.zzZ(colorArray2, f);
        }
        if (this.zzD7 >>> 24 == 255) {
            this.model = this.xrgbmodel;
            return;
        }
        this.model = ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < w || raster.getHeight() < h) {
            this.saved = raster = zzMS.getCachedRaster(this.model, w, h);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n = dataBufferInt.getOffset();
        int n2 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n3 = n2 - w;
        this.fillRaster(nArray, n, n3, x, y, w, h);
        return raster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    @Override
    public ColorModel getColorModel() {
        return this.model;
    }

    @Override
    public void dispose() {
        if (this.saved != null) {
            zzMS.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    private void zzZ(Color[] colorArray, float f) {
        int n;
        int n2;
        this.isSimpleLookup = true;
        int n3 = 1;
        for (n2 = 0; n2 < this.zzD6.length; ++n2) {
            n = (int)(this.normalizedIntervals[n2] / f * 255.0f);
            n3 += n;
            this.zzD6[n2] = new int[n];
            int n4 = colorArray[n2].getRGB();
            int n5 = colorArray[n2 + 1].getRGB();
            zzMS.zzV(n4, n5, this.zzD6[n2]);
            this.zzD7 &= n4;
            this.zzD7 &= n5;
        }
        this.gradient = new int[n3];
        n2 = 0;
        for (n = 0; n < this.zzD6.length; ++n) {
            System.arraycopy(this.zzD6[n], 0, this.gradient, n2, this.zzD6[n].length);
            n2 += this.zzD6[n].length;
        }
        this.gradient[this.gradient.length - 1] = colorArray[colorArray.length - 1].getRGB();
        if (this.zzDf == zzK2.zzZ.zzzx) {
            for (n = 0; n < this.gradient.length; ++n) {
                this.gradient[n] = zzMS.zzWW(this.gradient[n]);
            }
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void zzY(Color[] colorArray) {
        int n;
        this.isSimpleLookup = false;
        for (n = 0; n < this.zzD6.length; ++n) {
            this.zzD6[n] = new int[256];
            int n2 = colorArray[n].getRGB();
            int n3 = colorArray[n + 1].getRGB();
            zzMS.zzV(n2, n3, this.zzD6[n]);
            this.zzD7 &= n2;
            this.zzD7 &= n3;
        }
        if (this.zzDf == zzK2.zzZ.zzzx) {
            for (n = 0; n < this.zzD6.length; ++n) {
                for (int i = 0; i < this.zzD6[n].length; ++i) {
                    this.zzD6[n][i] = zzMS.zzWW(this.zzD6[n][i]);
                }
            }
        }
    }

    private static void zzV(int n, int n2, int[] nArray) {
        float f = 1.0f / (float)nArray.length;
        int n3 = n >>> 24;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = (n2 >>> 24) - n3;
        int n8 = (n2 >> 16 & 0xFF) - n4;
        int n9 = (n2 >> 8 & 0xFF) - n5;
        int n10 = (n2 & 0xFF) - n6;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)((double)((float)n3 + (float)(i * n7) * f) + 0.5) << 24 | (int)((double)((float)n4 + (float)(i * n8) * f) + 0.5) << 16 | (int)((double)((float)n5 + (float)(i * n9) * f) + 0.5) << 8 | (int)((double)((float)n6 + (float)(i * n10) * f) + 0.5);
        }
    }

    private static int zzWW(int n) {
        int n2 = n >>> 24;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = zzDa[n3];
        n4 = zzDa[n4];
        n5 = zzDa[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    protected final int indexIntoGradientsArrays(float position) {
        int n;
        if (this.zzDg == zzK2.zzY.zzzv) {
            if (position > 1.0f) {
                position = 1.0f;
            } else if (position < 0.0f) {
                position = 0.0f;
            }
        } else if (this.zzDg == zzK2.zzY.zzzt) {
            float f;
            position -= (float)((int)position);
            if (f < 0.0f) {
                position += 1.0f;
            }
        } else {
            if (position < 0.0f) {
                position = -position;
            }
            n = (int)position;
            position -= (float)n;
            if ((n & 1) == 1) {
                position = 1.0f - position;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(position * (float)this.fastGradientArraySize)];
        }
        for (n = 0; n < this.zzD6.length; ++n) {
            if (!(position < this.fractions[n + 1])) continue;
            float f = position - this.fractions[n];
            int n2 = (int)(f / this.normalizedIntervals[n] * 255.0f);
            return this.zzD6[n][n2];
        }
        return this.zzD6[this.zzD6.length - 1][255];
    }

    private static synchronized Raster getCachedRaster(ColorModel cm, int w, int h) {
        Raster raster;
        if (cm == cachedModel && cached != null && (raster = (Raster)cached.get()) != null && raster.getWidth() >= w && raster.getHeight() >= h) {
            cached = null;
            return raster;
        }
        return cm.createCompatibleWritableRaster(w, h);
    }

    private static synchronized void putCachedRaster(ColorModel cm, Raster ras) {
        Raster raster;
        if (cached != null && (raster = (Raster)cached.get()) != null) {
            int n = raster.getWidth();
            int n2 = raster.getHeight();
            int n3 = ras.getWidth();
            int n4 = ras.getHeight();
            if (n >= n3 && n2 >= n4) {
                return;
            }
            if (n * n2 >= n3 * n4) {
                return;
            }
        }
        cachedModel = cm;
        cached = new WeakReference<Raster>(ras);
    }

    static {
        zzDb = new int[256];
        zzDa = new int[256];
        for (int i = 0; i < 256; ++i) {
            float f;
            float f2;
            int n = i;
            float f3 = (float)n / 255.0f;
            float f4 = f2 <= 0.04045f ? f3 / 12.92f : (float)Math.pow(((double)f3 + 0.055) / 1.055, 2.4);
            zzMS.zzDb[i] = Math.round(f4 * 255.0f);
            n = i;
            f3 = (float)n / 255.0f;
            f4 = (double)f <= 0.0031308 ? f3 * 12.92f : 1.055f * (float)Math.pow(f3, 0.4166666666666667) - 0.055f;
            zzMS.zzDa[i] = Math.round(f4 * 255.0f);
        }
    }
}

