/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingMrSIDNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.MultiBandImportMode;
import com.supermap.data.conversion.a;

public class ImportSettingMrSID
extends ImportSetting {
    public ImportSettingMrSID() {
        long l = ImportSettingMrSIDNative.jni_New();
        this.setHandle(l, true);
        this.setMultiBandImportMode(MultiBandImportMode.MULTIBAND);
        super.a(com.supermap.data.conversion.a.b);
    }

    public ImportSettingMrSID(ImportSettingMrSID importSettingMrSID) {
        if (importSettingMrSID == null) {
            String string = InternalResource.loadString("importSettingMrSID", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingMrSID);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingMrSID", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingMrSIDNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingMrSID.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingMrSID.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingMrSID.getTargetPrjCoordSys());
        super.a(com.supermap.data.conversion.a.b);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingMrSID));
    }

    public ImportSettingMrSID(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingMrSID(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingMrSIDNative.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingMrSIDNative.jni_SetImportingAsGrid(this.getHandle(), value);
    }

    public MultiBandImportMode getMultiBandImportMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMultiBandImportMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingMrSIDNative.jni_GetMultiBandImportMode(this.getHandle());
        return (MultiBandImportMode)InternalEnum.parseUGCValue(MultiBandImportMode.class, n);
    }

    public void setMultiBandImportMode(MultiBandImportMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMultiBandImportMode(MultiBandImportMode mode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (mode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMrSIDNative.jni_SetMultiBandImportMode(this.getHandle(), mode.value());
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingMrSIDNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingMrSIDNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingMrSIDNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingMrSIDNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] ignoreValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (ignoreValues == null) {
            ignoreValues = new double[]{};
        }
        ImportSettingMrSIDNative.jni_SetIgnoreValues(this.getHandle(), ignoreValues);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingMrSIDNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }
}

