/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingKMLNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.a;

public class ImportSettingKML
extends ImportSetting {
    public ImportSettingKML() {
        long l = ImportSettingKMLNative.jni_New();
        this.setHandle(l, true);
        super.a(com.supermap.data.conversion.a.a);
    }

    public ImportSettingKML(ImportSettingKML importsettingKML) {
        if (importsettingKML == null) {
            String string = InternalResource.loadString("ImportSettingKML", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = importsettingKML.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingKML", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingKMLNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importsettingKML.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importsettingKML.getTargetDatasource());
        this.setUnvisibleObjectIgnored(importsettingKML.isUnvisibleObjectIgnored());
        this.setImportingAsCAD(importsettingKML.isImportingAsCAD());
        super.a(com.supermap.data.conversion.a.a);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importsettingKML));
    }

    public ImportSettingKML(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        super.a(com.supermap.data.conversion.a.a);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingKML(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        super.a(com.supermap.data.conversion.a.a);
    }

    public ImportSettingKML(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo, boolean importingAsCAD) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        this.setImportingAsCAD(importingAsCAD);
        super.a(com.supermap.data.conversion.a.a);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMLNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMLNative.jni_SetImportingAsCAD(this.getHandle(), value);
    }

    public boolean isUnvisibleObjectIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMLNative.jni_GetUnvisibleObjectIgnored(this.getHandle());
    }

    public void setUnvisibleObjectIgnored(boolean bvisible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMLNative.jni_SetUnvisibleObjectIgnored(this.getHandle(), bvisible);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingKMLNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMLNative.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMLNative.jni_IsImportEmptyDT(this.getHandle());
    }

    public void setImporttingAs3D(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImporttingAs3D()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingKMLNative.jni_SetImportingAs3D(this.getHandle(), value);
    }

    public boolean isImporttingAs3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImporttingAs3D()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingKMLNative.jni_IsImportingAs3D(this.getHandle());
    }
}

