/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingGIFNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.a;
import java.io.File;

public class ImportSettingGIF
extends ImportSetting {
    public ImportSettingGIF() {
        long l = ImportSettingGIFNative.jni_New();
        this.setHandle(l, true);
        super.a(com.supermap.data.conversion.a.b);
    }

    public ImportSettingGIF(ImportSettingGIF importSettingGIF) {
        if (importSettingGIF == null) {
            String string = InternalResource.loadString("importSettingGIF", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingGIF);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingGIF", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingGIFNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingGIF.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingGIF.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingGIF.getTargetPrjCoordSys());
        super.a(com.supermap.data.conversion.a.b);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingGIF));
    }

    public ImportSettingGIF(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        super.a(com.supermap.data.conversion.a.b);
    }

    public ImportSettingGIF(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        super.a(com.supermap.data.conversion.a.b);
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingGIFNative.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingGIFNative.jni_SetImportingAsGrid(this.getHandle(), value);
    }

    public boolean isPyramidBuilt() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isPyramidBuilt()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingGIFNative.jni_IsPyramidBuilt(this.getHandle());
    }

    public void setPyramidBuilt(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPyramidBuilt(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingGIFNative.jni_SetPyramidBuilt(this.getHandle(), value);
    }

    public String getWorldFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorldFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingGIFNative.jni_GetWorldFilePath(this.getHandle());
    }

    public void setWorldFilePath(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWorldFilePath(String value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(value);
        if (!file.exists()) {
            String string = InternalResource.loadString("", "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingGIFNative.jni_SetWorldFilePath(this.getHandle(), value);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingGIFNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingGIFNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingGIFNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingGIFNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] ignoreValues) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (ignoreValues == null) {
            ignoreValues = new double[]{};
        }
        ImportSettingGIFNative.jni_SetIgnoreValues(this.getHandle(), ignoreValues);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingGIFNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

