/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.ElevationData;
import com.supermap.data.ElevationDataNative;
import com.supermap.data.ElevationDataType;
import com.supermap.data.EngineType;
import com.supermap.data.InternalResource;
import java.io.File;

public class UserDEM
extends ElevationData {
    public UserDEM() {
        this.m_eType = ElevationDataType.USERDEM;
        long l = ElevationDataNative.jni_New(this.m_eType.a());
        this.setHandle(l, true);
        this.m_ugcRawPointerHandle = ElevationDataNative.jni_GetRawPointerHandle(l);
    }

    public UserDEM(String[] elevationData) {
        this.m_eType = ElevationDataType.USERDEM;
        long l = ElevationDataNative.jni_New(this.m_eType.a());
        this.setHandle(l, true);
        this.setElevationData(elevationData);
        this.m_ugcRawPointerHandle = ElevationDataNative.jni_GetRawPointerHandle(l);
    }

    UserDEM(long handle) {
        this.m_eType = ElevationDataType.USERDEM;
        this.setHandle(handle, true);
        this.m_ugcRawPointerHandle = ElevationDataNative.jni_GetRawPointerHandle(handle);
    }

    public void setElevationData(String[] elevationData) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ElevationData", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        if (elevationData == null) {
            String string = InternalResource.loadString("elevationData", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        for (int i = 0; i < elevationData.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string = elevationData[i];
            if (string == null || string.isEmpty()) {
                object3 = InternalResource.loadString(String.format("elevationData[%d]", i), "Global_ArgumentNull", "data_resources");
                throw new NullPointerException((String)object3);
            }
            object3 = new File(string);
            if (!((File)object3).exists()) {
                object2 = InternalResource.loadString(string, "Global_FileNotExists", "data_resources");
                throw new IllegalArgumentException((String)object2);
            }
            object2 = new DatasourceConnectionInfo();
            ((DatasourceConnectionInfo)object2).setEngineType(EngineType.IMAGEPLUGINS);
            ((DatasourceConnectionInfo)object2).setServer(string);
            Datasource datasource = new Datasource(EngineType.IMAGEPLUGINS);
            if (!datasource.open((DatasourceConnectionInfo)object2)) {
                object = InternalResource.loadString(string, "String_OpenImageFileAsDatasourceFailed", "data_resources");
                throw new IllegalArgumentException((String)object);
            }
            if (datasource.getDatasets().getCount() == 0) {
                datasource.close();
                object = InternalResource.loadString(string, "String_InvalidImagePluginDatasource", "data_resources");
                throw new IllegalArgumentException((String)object);
            }
            object = (DatasetImage)datasource.getDatasets().get(0);
            if (object == null) {
                datasource.close();
                String string2 = InternalResource.loadString(string, "String_InvalidImagePluginDatasource", "data_resources");
                throw new IllegalArgumentException(string2);
            }
            if (((DatasetImage)object).getBandCount() != 1) {
                datasource.close();
                String string3 = InternalResource.loadString(string, "String_ElevationDatasetMustOneBand", "data_resources");
                throw new IllegalArgumentException(string3);
            }
            datasource.close();
        }
        ElevationDataNative.jni_SetUserDemFiles(this.getHandle(), elevationData);
    }

    public String[] getElevationData() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ElevationData", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        return ElevationDataNative.jni_GetUserDemFiles(this.getHandle());
    }
}

