/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.InternalVariantNative;
import com.supermap.data.InternalVariantType;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Pattern;

class InternalVariant
extends InternalHandleDisposable {
    protected InternalVariant() {
        this.setHandle(InternalVariantNative.jni_New(), true);
    }

    public InternalVariant(Object obj) {
        this();
        if (obj.getClass().equals(Byte.class)) {
            Byte by = (Byte)obj;
            this.setValue(by);
        } else if (obj.getClass().equals(Integer.class)) {
            Integer n = (Integer)obj;
            this.setValue(n);
        } else if (obj.getClass().equals(Long.class)) {
            Long l = (Long)obj;
            this.setValue(l);
        } else if (obj.getClass().equals(Short.class)) {
            Short s = (Short)obj;
            this.setValue(s);
        } else if (obj.getClass().equals(Boolean.class)) {
            Boolean bl = (Boolean)obj;
            this.setValue(bl);
        } else if (obj.getClass().equals(Float.class)) {
            Float f2 = (Float)obj;
            this.setValue(f2.floatValue());
        } else if (obj.getClass().equals(Double.class)) {
            Double d2 = (Double)obj;
            this.setValue(d2);
        } else if (obj.getClass().equals(String.class)) {
            String string = (String)obj;
            this.setValue(string);
        } else if (obj.getClass().equals(Date.class)) {
            Date date = (Date)obj;
            this.setValue(date);
        } else if (obj.getClass().equals(byte[].class)) {
            byte[] byArray = (byte[])obj;
            this.setValue(byArray);
        } else {
            String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "data_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public InternalVariant(byte value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(int value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(long value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(short value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(boolean value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(float value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(double value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(String value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(Date value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(byte[] value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(Byte[] value) {
        this();
        this.setValue(value);
    }

    public InternalVariantType getType() {
        int n = InternalVariantNative.jni_GetType(this.getHandle());
        InternalVariantType internalVariantType = (InternalVariantType)Enum.parseUGCValue(InternalVariantType.class, n);
        return internalVariantType;
    }

    public void setValue(byte value) {
        InternalVariantNative.jni_SetValueByte(this.getHandle(), value);
    }

    public void setValue(int value) {
        InternalVariantNative.jni_SetValueInt(this.getHandle(), value);
    }

    public void setValue(long value) {
        InternalVariantNative.jni_SetValueLong(this.getHandle(), value);
    }

    public void setValue(short value) {
        InternalVariantNative.jni_SetValueShort(this.getHandle(), value);
    }

    public void setValue(boolean value) {
        InternalVariantNative.jni_SetValueBoolean(this.getHandle(), value);
    }

    public void setValue(float value) {
        InternalVariantNative.jni_SetValueFloat(this.getHandle(), value);
    }

    public void setValue(double value) {
        InternalVariantNative.jni_SetValueDouble(this.getHandle(), value);
    }

    public void setValue(String value) {
        InternalVariantNative.jni_SetValueString(this.getHandle(), value);
    }

    public void setValue(byte[] value) {
        InternalVariantNative.jni_SetValueBinary(this.getHandle(), value);
    }

    public void setValue(Byte[] value) {
        byte[] byArray = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            byArray[i] = value[i];
        }
        InternalVariantNative.jni_SetValueBinary(this.getHandle(), byArray);
    }

    public void setValue(Date value) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.setTime(value);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        InternalVariantNative.jni_SetValueTime(this.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public int toByte() {
        return InternalVariantNative.jni_GetValueByte(this.getHandle());
    }

    public int toInt() {
        return InternalVariantNative.jni_GetValueInt(this.getHandle());
    }

    public long toLong() {
        return InternalVariantNative.jni_GetValueLong(this.getHandle());
    }

    public short toShort() {
        return InternalVariantNative.jni_GetValueShort(this.getHandle());
    }

    public boolean toBoolean() {
        return InternalVariantNative.jni_GetValueBoolean(this.getHandle());
    }

    public double toDouble() {
        return InternalVariantNative.jni_GetValueDouble(this.getHandle());
    }

    public float toFloat() {
        return InternalVariantNative.jni_GetValueFloat(this.getHandle());
    }

    public byte[] toBinary() {
        return InternalVariantNative.jni_GetValueBinary(this.getHandle());
    }

    public String toString() {
        String string = null;
        if (this.getType().equals(InternalVariantType.TIME) || this.getType().equals(InternalVariantType.DATE) || this.getType().equals(InternalVariantType.TIMESTAMP)) {
            Date date = this.toDate();
            string = DateFormat.getDateInstance().format(date);
        } else {
            string = InternalVariantNative.jni_GetValueString(this.getHandle());
        }
        return string;
    }

    public Date toDate() {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = InternalVariantNative.jni_GetValueString(this.getHandle());
        Date date = null;
        if (pattern.matcher(string).matches()) {
            try {
                date = DateFormat.getDateInstance().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public Object toObject() {
        InternalVariantType internalVariantType = this.getType();
        if (internalVariantType.equals(InternalVariantType.BYTE)) {
            return Byte.valueOf(String.valueOf(this.toByte()));
        }
        if (internalVariantType.equals(InternalVariantType.BOOLEAN)) {
            return this.toBoolean();
        }
        if (internalVariantType.equals(InternalVariantType.INTEGER)) {
            return this.toInt();
        }
        if (internalVariantType.equals(InternalVariantType.LONG)) {
            return this.toLong();
        }
        if (internalVariantType.equals(InternalVariantType.SHORT)) {
            return this.toShort();
        }
        if (internalVariantType.equals(InternalVariantType.FLOAT)) {
            return Float.valueOf(this.toFloat());
        }
        if (internalVariantType.equals(InternalVariantType.DOUBLE)) {
            return this.toDouble();
        }
        if (internalVariantType.equals(InternalVariantType.TIME) || internalVariantType.equals(InternalVariantType.DATE) || internalVariantType.equals(InternalVariantType.TIMESTAMP)) {
            return this.toDate();
        }
        if (internalVariantType.equals(InternalVariantType.STRING)) {
            return this.toString();
        }
        if (internalVariantType.equals(InternalVariantType.BINARY)) {
            return this.toBinary();
        }
        if (internalVariantType.equals(InternalVariantType.NULL)) {
            return null;
        }
        String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "data_resources");
        throw new IllegalArgumentException(string);
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            InternalVariantNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    private InternalVariant(long handle, boolean empty) {
        this.setHandle(handle, true);
    }

    static final InternalVariant createInstance(long handle) {
        return new InternalVariant(handle, true);
    }

    static boolean isSupportedInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(Byte.class)) {
            return true;
        }
        if (obj.getClass().equals(Integer.class)) {
            return true;
        }
        if (obj.getClass().equals(Long.class)) {
            return true;
        }
        if (obj.getClass().equals(Short.class)) {
            return true;
        }
        if (obj.getClass().equals(Boolean.class)) {
            return true;
        }
        if (obj.getClass().equals(Float.class)) {
            return true;
        }
        if (obj.getClass().equals(Double.class)) {
            return true;
        }
        if (obj.getClass().equals(String.class)) {
            return true;
        }
        if (obj.getClass().equals(Date.class)) {
            return true;
        }
        return obj.getClass().equals(byte[].class);
    }
}

