/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.HistoricalMomentNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.ToolkitNative;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class HistoricalMoment
extends InternalHandleDisposable {
    private HistoricalMoment() {
    }

    protected HistoricalMoment(long handle) {
        this.setHandle(handle, true);
    }

    public String getName() {
        this.a();
        String string = HistoricalMomentNative.jni_GetName(this.getHandle());
        return string;
    }

    public Date getEndTime() {
        Date date;
        this.a();
        String string = HistoricalMomentNative.jni_GetEndTime(this.getHandle());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }

    public boolean alterName(String strNewName) {
        this.a();
        this.a(strNewName);
        return HistoricalMomentNative.jni_AlterName(this.getHandle(), strNewName);
    }

    public boolean alterEndTime(Date endTime) {
        this.a();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(endTime);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = String.format("%d-%d-%d %d:%d:%d", n, n2, n3, n4, n5, n6);
        return HistoricalMomentNative.jni_AlterEndTime(this.getHandle(), string);
    }

    public boolean delete() {
        this.a();
        return HistoricalMomentNative.jni_DeleteHisVersion(this.getHandle());
    }

    @Override
    public void dispose() {
        this.dispose(() -> {
            HistoricalMomentNative.jni_Delete(this.getHandle());
            this.clearHandle();
        });
    }

    private void a() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    private void a(String string) {
        int n = ToolkitNative.jni_IsValidDatasetName(string);
        if (n == -1) {
            return;
        }
        InternalInvalidState internalInvalidState = (InternalInvalidState)Enum.parseUGCValue(InternalInvalidState.class, n);
        if (internalInvalidState != null) {
            String string2 = "HistoricalMoment name is " + internalInvalidState.name() + ", valid name = " + string;
            throw new IllegalArgumentException(string2);
        }
    }
}

