/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegionNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class GeoRegion
extends Geometry {
    private List<Point2Ds> a;

    public GeoRegion() {
        super.setHandle(GeoRegionNative.jni_New(), true);
        this.a = new ArrayList<Point2Ds>();
    }

    public GeoRegion(GeoRegion region) {
        if (region == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (region.getHandle() == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoRegionNative.jni_Clone(region.getHandle());
        super.setHandle(l, true);
        this.a = new ArrayList<Point2Ds>(region.a().size());
        for (int i = 0; i < region.a().size(); ++i) {
            this.a.add(new Point2Ds(this));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(region);
    }

    public GeoRegion(Point2Ds points) {
        this();
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("convertToRegion", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.addPart(points);
    }

    public int addPart(Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        int n2 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds = new Point2Ds(this);
        this.a.add(point2Ds);
        return n2;
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoRegionNative.jni_ConvertToLine(this.getHandle());
        if (l != 0L) {
            GeoLine geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }

    public Point2Ds getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    public boolean insertPart(int index, Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = points.getCount();
        if (n < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        if (index == this.getPartCount()) {
            int n2 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds = new Point2Ds(this);
            this.a.add(index, point2Ds);
            return n2 != -1;
        }
        boolean bl = GeoRegionNative.jni_InsertPart(this.getHandle(), index, dArray, dArray2);
        Point2Ds point2Ds = new Point2Ds(this);
        this.a.add(index, point2Ds);
        return bl;
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegionNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.a.remove(index);
        }
        return bl;
    }

    public boolean setPart(int index, Point2Ds points) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (points.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = points.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = points.getItem(i).getX();
            dArray2[i] = points.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), index, dArray, dArray2);
        return bl;
    }

    boolean a(int n, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds.getCount() < 3) {
            String string = InternalResource.loadString("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = point2Ds.getCount();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = point2Ds.getItem(i).getX();
            dArray2[i] = point2Ds.getItem(i).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), n, dArray, dArray2);
        return bl;
    }

    public int indexOf(Point2Ds part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.indexOf(part);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPerimeter(this.getHandle());
    }

    public boolean isCounterClockwise(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isCounterClockwise(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return GeoRegionNative.jni_IsCounterClockwise(this.getHandle(), index) > 0;
    }

    @Override
    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = super.fromXML(xml);
        if (bl) {
            this.b();
        }
        return bl;
    }

    @Override
    public Geometry mirror(Point2D startPoint, Point2D endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion = (GeoRegion)super.mirror(startPoint, endPoint);
        int n = geoRegion.getPartCount();
        geoRegion.a = new ArrayList<Point2Ds>();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(geoRegion);
            geoRegion.a.add(point2Ds);
        }
        return geoRegion;
    }

    @Override
    public void offset(double dx, double dy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(dx, dy);
        this.c();
    }

    @Override
    public void resize(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.resize(bounds);
        this.c();
    }

    @Override
    public void rotate(Point2D basePoint, double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(basePoint, angle);
        this.c();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoRegion region) {
        region.clearHandle();
    }

    protected void changeHandle(long regionHandle) {
        if (regionHandle == 0L) {
            String string = InternalResource.loadString("regionHandle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setIsDisposable(true);
        this.dispose();
        this.setHandle(regionHandle, false);
    }

    protected static void changeHandle(GeoRegion region, long regionHandle) {
        region.changeHandle(regionHandle);
    }

    List<Point2Ds> a() {
        return this.a;
    }

    private Point2D[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoRegionNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 2) {
            Point2D[] point2DArray = new Point2D[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            GeoRegionNative.jni_GetPart(this.getHandle(), n, dArray, dArray2);
            for (int i = 0; i < n2; ++i) {
                point2DArray[i] = new Point2D(dArray[i], dArray2[i]);
            }
            return point2DArray;
        }
        return null;
    }

    private void c() {
    }

    void b() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            Point2Ds point2Ds = new Point2Ds(this);
            this.a.add(point2Ds);
        }
    }

    @Override
    public GeoRegion clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        this.dispose(() -> {
            GeoRegionNative.jni_Delete(this.getHandle());
            this.clearHandle();
        });
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRegionNative.jni_Clear(this.getHandle());
        this.a.clear();
    }

    GeoRegion(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList<Point2Ds>();
        this.b();
    }

    @Override
    protected void refreshHandle(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, false);
        if (this.a != null && this.a.size() > 0) {
            this.a.clear();
        } else {
            this.a = new ArrayList<Point2Ds>();
        }
        this.b();
    }

    protected static void refreshHandle(GeoRegion geoRegion, long handle) {
        geoRegion.refreshHandle(handle);
    }

    public GeoRegion[] protectedDecompose() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("protectedDecompose()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeoRegionNative.jni_ProtectedDecompose(this.getHandle());
        if (lArray != null && lArray.length > 0) {
            GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                geoRegionArray[i] = new GeoRegion(lArray[i]);
                geoRegionArray[i].setIsDisposable(true);
            }
            return geoRegionArray;
        }
        return null;
    }

    public double getPreciseArea(PrjCoordSys prjCoordSys) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreciseArea(PrjCoordSys prjCoordSys)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = InternalResource.loadString("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = GeoRegionNative.jni_GetPreciseArea(this.getHandle(), prjCoordSys.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(prjCoordSys);
        return d2;
    }

    public int[] getPartTopo() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartTopo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isEmpty()) {
            return null;
        }
        int[] nArray = GeoRegionNative.jni_GetPartTopo(this.getHandle());
        return nArray;
    }
}

