/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoMultiSurfaceNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class GeoMultiSurface
extends Geometry {
    public GeoMultiSurface() {
        long l = GeoMultiSurfaceNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoMultiSurface(GeoMultiSurface geoMCurve) {
        if (geoMCurve == null) {
            String string = InternalResource.loadString("GeoMultiSurface", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMCurve);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoMultiSurface", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMultiSurfaceNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoMCurve);
    }

    GeoMultiSurface(long handle) {
        this.setHandle(handle, false);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMultiSurfaceNative.jni_GetLength(this.getHandle());
    }

    public int getNumGeometries() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMultiSurfaceNative.jni_GetNumGeometries(this.getHandle());
    }

    public boolean addGeometry(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addGeometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoMultiSurfaceNative.jni_AddGeometry(this.getHandle(), geometry.getHandle());
    }

    public boolean removeGeometry(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemovePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMultiSurfaceNative.jni_RemoveGeometry(this.getHandle(), index);
    }

    public Geometry getGeometry(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeometry(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getNumGeometries()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = GeoMultiSurfaceNative.jni_GetGeometry(this.getHandle(), index);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = GeoMultiSurface.createInstance(l);
        }
        return geometry;
    }

    public GeoRegion convertToGeoRegion(int pointCountPerSegment) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoMultiSurfaceNative.jni_ConvertToRegion(this.getHandle(), pointCountPerSegment);
        GeoRegion geoRegion = null;
        if (l != 0L) {
            geoRegion = new GeoRegion(l);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMultiSurfaceNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    @Override
    public Geometry clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMultiSurface(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMultiSurfaceNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

