/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoLineEPSNative;
import com.supermap.data.GeometryParametric;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class GeoLineParametric
extends GeometryParametric {
    public GeoLineParametric() {
        long l = GeoLineEPSNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoLineParametric(GeoLineParametric geoLine) {
        if (geoLine == null) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLine", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineEPSNative.jni_Clone(geoLine.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
    }

    GeoLineParametric(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public GeoLineParametric clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLineParametric(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLineEPSNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineEPSNative.jni_GetLength(this.getHandle());
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineEPSNative.jni_ConvertToLine(this.getHandle());
        if (l != 0L) {
            GeoLine geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }

    public GeoLine3D convertToLine3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineEPSNative.jni_ConvertToLine3D(this.getHandle());
        if (l != 0L) {
            GeoLine3D geoLine3D = new GeoLine3D(l);
            geoLine3D.setIsDisposable(true);
            return geoLine3D;
        }
        return null;
    }
}

