/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CalibrateMeasureMethod;
import com.supermap.data.CalibrateMode;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLineMNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.PointM;
import com.supermap.data.PointMs;
import com.supermap.data.Rectangle2D;
import com.supermap.data.WhereToCalibrate;
import java.util.ArrayList;

public class GeoLineM
extends Geometry {
    private ArrayList<PointMs> a;

    ArrayList<PointMs> a() {
        return this.a;
    }

    public GeoLineM() {
        long l = GeoLineMNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    public GeoLineM(GeoLineM geoLineM) {
        if (geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("geoLineM", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineMNative.jni_Clone(geoLineM.getHandle());
        this.setHandle(l, true);
        this.a = new ArrayList();
        for (int i = 0; i < geoLineM.a().size(); ++i) {
            PointMs pointMs = geoLineM.a().get(i);
            this.a.add(pointMs.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLineM);
    }

    public GeoLineM(PointMs pointMs) {
        this();
        this.addPart(pointMs);
    }

    GeoLineM(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList();
        this.b();
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public GeoLineM clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoLineM(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoLineMNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetLength(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(PointMs pointMs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPart(PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = pointMs.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("pointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pointMs.getItem(i).getX();
            dArray2[i] = pointMs.getItem(i).getY();
            dArray3[i] = pointMs.getItem(i).getM();
        }
        PointMs pointMs2 = new PointMs(pointMs, this);
        this.a.add(pointMs2);
        return GeoLineMNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoLineMNative.jni_RemovePart(this.getHandle(), index);
        if (bl) {
            this.a.remove(index);
        }
        return bl;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_Clear(this.getHandle());
        this.a.clear();
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineMNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = new GeoRegion(l);
        geoRegion.setIsDisposable(true);
        if (this.getPartCount() != geoRegion.getPartCount()) {
            String string = InternalResource.loadString("convertToRegion", "GeoLine_UnsupportOperation", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        return geoRegion;
    }

    public Point2D findPointOnLineByDistance(double distance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findPointOnLineByDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (distance < 0.0) {
            String string = InternalResource.loadString("distance", "GeoLine_ArgumentShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2D point2D = new Point2D();
        if (this.getPartCount() > 0) {
            double[] dArray = new double[2];
            GeoLineMNative.jni_FindPointOnLineByDistance(this.getHandle(), distance, dArray);
            point2D.setX(dArray[0]);
            point2D.setY(dArray[1]);
        }
        return point2D;
    }

    public PointMs getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    public boolean insertPart(int index, PointMs pointMs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.getPartCount();
        if (n == index) {
            int n2 = this.addPart(pointMs);
            boolean bl2 = bl = n2 == index;
            if (bl) {
                PointMs pointMs2 = new PointMs(pointMs, this);
                this.a.add(index, pointMs2);
            }
            return bl;
        }
        if (index < 0 || index > this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = pointMs.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = pointMs.getItem(i).getX();
            dArray2[i] = pointMs.getItem(i).getY();
            dArray3[i] = pointMs.getItem(i).getM();
        }
        bl = GeoLineMNative.jni_InsertPart(this.getHandle(), index, dArray, dArray2, dArray3);
        if (bl) {
            PointMs pointMs3 = new PointMs(pointMs, this);
            this.a.add(index, pointMs3);
        }
        return bl;
    }

    public int indexOf(PointMs part) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(PointMs part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.indexOf(part);
    }

    public boolean reverse() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverse()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineMNative.jni_Reverse(this.getHandle());
        this.c();
        return bl;
    }

    public boolean reverseMOrder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseMOrder()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineMNative.jni_ReverseMOrder(this.getHandle());
        if (bl) {
            this.c();
            return true;
        }
        return false;
    }

    public boolean setPart(int index, PointMs pointMs) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = pointMs.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = pointMs.getItem(n).getX();
            dArray2[n] = pointMs.getItem(n).getY();
            dArray3[n] = pointMs.getItem(n).getM();
        }
        n = GeoLineMNative.jni_SetPart(this.getHandle(), index, dArray, dArray2, dArray3) ? 1 : 0;
        if (n == 1) {
            PointMs pointMs2 = this.a.get(index);
            PointMs pointMs3 = new PointMs(pointMs, this);
            this.a.set(index, pointMs3);
            pointMs2.a(null);
        }
        return n != 0;
    }

    boolean a(int n, PointMs pointMs) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPart(int index, PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = pointMs.getCount();
        if (n3 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = pointMs.getItem(n2).getX();
            dArray2[n2] = pointMs.getItem(n2).getY();
            dArray3[n2] = pointMs.getItem(n2).getM();
        }
        n2 = GeoLineMNative.jni_SetPart(this.getHandle(), n, dArray, dArray2, dArray3) ? 1 : 0;
        return n2 != 0;
    }

    @Override
    public boolean fromXML(String xml) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = super.fromXML(xml);
        if (bl) {
            this.b();
        }
        return bl;
    }

    @Override
    public Geometry mirror(Point2D startPoint, Point2D endPoint) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("mirror(Point2D startPoint, Point2D endPoint)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineM geoLineM = (GeoLineM)super.mirror(startPoint, endPoint);
        int n = geoLineM.getPartCount();
        geoLineM.a = new ArrayList();
        for (int i = 0; i < n; ++i) {
            PointMs pointMs = new PointMs(geoLineM.a(i));
            PointMs pointMs2 = new PointMs(pointMs, geoLineM);
            geoLineM.a.add(pointMs2);
        }
        return geoLineM;
    }

    @Override
    public void offset(double dx, double dy) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.offset(dx, dy);
        this.c();
    }

    public void offsetMeasure(double measure) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("offset(double dx, double dy)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_OffsetMeasure(this.getHandle(), measure);
        this.c();
    }

    @Override
    public void resize(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("resize(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.resize(bounds);
        this.c();
    }

    @Override
    public void rotate(Point2D basePoint, double angle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rotate(Point2D basePoint, double angle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        super.rotate(basePoint, angle);
        this.c();
    }

    public double getMaxM() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxM()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMaxM(this.getHandle());
    }

    public double getMinM() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinM()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMinM(this.getHandle());
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineMNative.jni_ConvertToLine(this.getHandle());
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public void setMAsDistance(double originM) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMAsDistance(double originM)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_SetMAsDistance(this.getHandle(), originM, 1.0, true);
        this.c();
    }

    public void setMAsDistance(double originM, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMAsDistance(double originM,double scale)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_SetMAsDistance(this.getHandle(), originM, scale, true);
        this.c();
    }

    public void setMAsDistance(double originM, double scale, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMAsDistance(double originM,double scale,boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_SetMAsDistance(this.getHandle(), originM, scale, isIgnoreGap);
        this.c();
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
    }

    protected static void clearHandle(GeoLineM lineM) {
        lineM.clearHandle();
    }

    private void c() {
        int n = this.getPartCount();
        for (int i = 0; i < n; ++i) {
            PointMs pointMs = this.a.get(i);
            pointMs.a(null);
            pointMs.clear();
            pointMs.addRange(this.a(i));
        }
    }

    private PointM[] a(int n) {
        if (n < 0 || n >= this.getPartCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = GeoLineMNative.jni_GetPartPointCount(this.getHandle(), n);
        if (n2 > 1) {
            PointM[] pointMArray = new PointM[n2];
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            GeoLineMNative.jni_GetPart(this.getHandle(), n, dArray, dArray2, dArray3);
            for (int i = 0; i < n2; ++i) {
                pointMArray[i] = new PointM(dArray[i], dArray2[i], dArray3[i]);
            }
            return pointMArray;
        }
        return null;
    }

    void b() {
        int n = this.getPartCount();
        this.a.clear();
        for (int i = 0; i < n; ++i) {
            PointMs pointMs = new PointMs(this.a(i));
            PointMs pointMs2 = new PointMs(pointMs, this);
            this.a.add(pointMs2);
        }
    }

    public Point2D getPointAtM(double measure) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtM(double measure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPointAtM(measure, 0.0, true);
    }

    public Point2D getPointAtM(double measure, double offset, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtM(double measure,double offset, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = new Point2D();
        double[] dArray = new double[2];
        GeoLineMNative.jni_GetPointAtM(this.getHandle(), dArray, measure, offset, isIgnoreGap);
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public Point2D getPointAtDistance(double distance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = new Point2D();
        double[] dArray = new double[2];
        GeoLineMNative.jni_GetPointAtDistance(this.getHandle(), dArray, distance, false);
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public Point2D getPointAtDistance(double distance, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPointAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Point2D point2D = new Point2D();
        double[] dArray = new double[2];
        GeoLineMNative.jni_GetPointAtDistance(this.getHandle(), dArray, distance, isIgnoreGap);
        point2D.setX(dArray[0]);
        point2D.setY(dArray[1]);
        return point2D;
    }

    public double getMAtDistance(double distance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMAtDistance(this.getHandle(), distance, true);
    }

    public double getMAtDistance(double distance, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMAtDistance(this.getHandle(), distance, isIgnoreGap);
    }

    public double getMAtDistance(double distance, int subindex, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetMAtDistanceSub(this.getHandle(), distance, subindex - 1, isIgnoreGap);
    }

    public double getDistanceAtM(double measure) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceAtM(double measure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetDistanceAtM(this.getHandle(), measure, false);
    }

    public double getDistanceAtM(double measure, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDistanceAtM(double measure,boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetDistanceAtM(this.getHandle(), measure, isIgnoreGap);
    }

    public double getDistanceAtM(double distance, int subindex, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtDistance(double distance, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoLineMNative.jni_GetDistanceAtMSub(this.getHandle(), distance, subindex - 1, isIgnoreGap);
    }

    public boolean setMAtPoint(Point2D point2D, double measure) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Point2D point2D, double measure,double tolorence,WhereToCalibrate wheretocalibrate)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        int n = GeoLineMNative.jni_SetMAtPoint(this.getHandle(), dArray, measure, 1.0E-6, 0);
        if (n != -1) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean setMAtPoint(Point2D point2D, double measure, double tolerance, WhereToCalibrate wheretocalibrate) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Point2D point2D, double measure,double tolorence,WhereToCalibrate wheretocalibrate)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        int n = wheretocalibrate.value();
        int n2 = GeoLineMNative.jni_SetMAtPoint(this.getHandle(), dArray, measure, tolerance, n);
        return n2 != -1;
    }

    public double getMAtPoint(Point2D point2D, double tolerance, boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMAtPoint(Point2D point2D, double tolerance,boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = -9999.0;
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        d2 = GeoLineMNative.jni_GetMAtPoint(this.getHandle(), dArray, tolerance, isIgnoreGap);
        return d2;
    }

    public GeoLine getSubCurveAtM(double fromMeasure, double toMeasure) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSubCurveAtM(double fromMeasure,double toMeasure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoLineMNative.jni_GetSubCurveAtM(this.getHandle(), fromMeasure, toMeasure);
        if (l != 0L) {
            GeoLine geoLine = (GeoLine)Geometry.createInstance(l);
            return geoLine;
        }
        return null;
    }

    public GeoLineM getSubLineMAtM(double startMeasure, double endMeasure) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineMAtM(double startMeasure, double endMeasure)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = 0.0;
        boolean bl = true;
        long l = GeoLineMNative.jni_GetLineMAtM(this.getHandle(), startMeasure, endMeasure, d2, bl);
        if (l != 0L) {
            GeoLineM geoLineM = (GeoLineM)Geometry.createInstance(l);
            return geoLineM;
        }
        return null;
    }

    public static GeoLineM union(GeoLineM geoLineM, GeoLineM otherLineM) {
        if (geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("geolinem", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (otherLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("otherLineM", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLineM geoLineM2 = new GeoLineM(geoLineM);
        int n = otherLineM.a().size();
        for (int i = 0; i < n; ++i) {
            geoLineM2.addPart(otherLineM.getPart(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLineM);
        InternalHandleDisposable.makeSureNativeObjectLive(otherLineM);
        InternalHandleDisposable.makeSureNativeObjectLive(geoLineM2);
        return geoLineM2;
    }

    public boolean joint(GeoLineM otherLineM) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Joint(GeoLineM otherLineM)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (otherLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("otherLineM", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = otherLineM.a().size();
        int n2 = this.getPartCount();
        PointMs pointMs = this.a().get(n2 - 1);
        PointMs pointMs2 = otherLineM.a().get(0);
        pointMs.addRange(pointMs2.toArray());
        for (int i = 1; i < n; ++i) {
            PointMs pointMs3 = otherLineM.a().get(i);
            this.a.add(pointMs3.clone());
        }
        InternalHandleDisposable.makeSureNativeObjectLive(otherLineM);
        return true;
    }

    public boolean split(Point2D splitPoint, GeoLineM geoLineM1, GeoLineM geoLineM2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Split(Point2D splitPoint,GeoLineM geolinem1,GeoLineM geolinem2)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{splitPoint.getX(), splitPoint.getY()};
        if (GeoLineMNative.jni_Split(this.getHandle(), dArray, geoLineM1.getHandle(), geoLineM2.getHandle())) {
            geoLineM1.b();
            geoLineM2.b();
            InternalHandleDisposable.makeSureNativeObjectLive(geoLineM1);
            InternalHandleDisposable.makeSureNativeObjectLive(geoLineM2);
            return true;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLineM1);
        InternalHandleDisposable.makeSureNativeObjectLive(geoLineM2);
        return false;
    }

    public boolean calibrateLineM(PointMs pointMs, CalibrateMode method, boolean isIgnoreGap) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CalibrateLineM(PointMs pointMs)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = pointMs.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = pointMs.getItem(n).getX();
            dArray2[n] = pointMs.getItem(n).getY();
            dArray3[n] = pointMs.getItem(n).getM();
        }
        n = GeoLineMNative.jni_CalibrateLineM(this.getHandle(), dArray, dArray2, dArray3, method.value(), isIgnoreGap) ? 1 : 0;
        if (n == 1) {
            this.a.clear();
            this.b();
        }
        return n != 0;
    }

    public boolean calibrateLineM(GeoLineM geoLineM, CalibrateMode method, boolean isIgnoreGap) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("(GeoLineM geoLineM, CalibrateMeasureMethod method, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geoLineM.getHandle() == 0L) {
            String string = InternalResource.loadString("(GeoLineM geoLineM, CalibrateMeasureMethod method, boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        PointMs pointMs = geoLineM.getPart(0);
        int n2 = pointMs.getCount();
        if (n2 < 2) {
            String string = InternalResource.loadString("PointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = pointMs.getItem(n).getX();
            dArray2[n] = pointMs.getItem(n).getY();
            dArray3[n] = pointMs.getItem(n).getM();
        }
        n = GeoLineMNative.jni_CalibrateLineM(this.getHandle(), dArray, dArray2, dArray3, method.getUGCValue(), isIgnoreGap) ? 1 : 0;
        if (n == 1) {
            this.a.clear();
            this.b();
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLineM);
        return n != 0;
    }

    public static GeoLineM clip(GeoLineM geometry, GeoRegion clipGeometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipGeometry == null || clipGeometry.getHandle() == 0L) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOLINEM) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipGeometry.getType() != GeometryType.GEOREGION) {
            String string = InternalResource.loadString("clipGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoLineMNative.jni_Clip(geometry.getHandle(), clipGeometry.getHandle());
        GeoLineM geoLineM = null;
        if (l != 0L) {
            geoLineM = (GeoLineM)Geometry.createInstance(l);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry);
        InternalHandleDisposable.makeSureNativeObjectLive(clipGeometry);
        return geoLineM;
    }

    public boolean updateM(Point2D fromPoint, Point2D toPoint, double fromMeasure, double toMeasure, double tolerance, WhereToCalibrate wheretoCalibrate, CalibrateMode calibrateMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("UpdateM(Point2D fromPoint,Point2D toPoint, double fromMeasure,double toMeasure,double tolerance, WhereToCalibrate wheretoCalibrate, CalibrateMeasureMethod method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{fromPoint.getX(), fromPoint.getY()};
        double[] dArray2 = new double[]{toPoint.getX(), toPoint.getY()};
        boolean bl = GeoLineMNative.jni_UpdateM(this.getHandle(), dArray, dArray2, fromMeasure, toMeasure, tolerance, wheretoCalibrate.value(), calibrateMode.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean updateM(int fromIndex, int toIndex, double fromMeasure, double toMeasure, WhereToCalibrate wheretoCalibrate, CalibrateMode calibrateMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("UpdateM(int fromIndex, int toIndex, double fromMeasure, double toMeasure,WhereToCalibrate wheretoCalibrate,CalibrateMode method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = GeoLineMNative.jni_UpdateMIndex(this.getHandle(), fromIndex, toIndex, fromMeasure, toMeasure, wheretoCalibrate.value(), calibrateMode.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean interpolateM(Point2D fromPoint, Point2D toPoint, double fromMeasure, double toMeasure, double tolerance, CalibrateMode method) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("InterpolateM(Point2D fromPoint,Point2D toPoint, double fromMeasure, double toMeasure,double tolerance, CalibrateMeasureMethod method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{fromPoint.getX(), fromPoint.getY()};
        double[] dArray2 = new double[]{toPoint.getX(), toPoint.getY()};
        boolean bl = GeoLineMNative.jni_InterpolateM(this.getHandle(), dArray, dArray2, fromMeasure, toMeasure, tolerance, method.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public boolean extrapolateM(Point2D fromPoint, Point2D toPoint, double fromMeasure, double toMeasure, double tolerance, CalibrateMode method) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ExtrapolateM(Point2D fromPoint,Point2D toPoint, double fromMeasure,double toMeasure,double tolerance, CalibrateMeasureMethod method)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{fromPoint.getX(), fromPoint.getY()};
        double[] dArray2 = new double[]{toPoint.getX(), toPoint.getY()};
        boolean bl = GeoLineMNative.jni_ExtrapolateM(this.getHandle(), dArray, dArray2, fromMeasure, toMeasure, tolerance, method.value());
        if (bl) {
            this.b();
            return true;
        }
        return false;
    }

    public void calculateNoM(boolean isIgnoreGap) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CalculateNoM(boolean isIgnoreGap)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLineMNative.jni_CalculateNoM(this.getHandle(), isIgnoreGap);
        this.b();
    }

    public static GeoLineM makeLineM(GeoLine geoLine, PointMs pointMs) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = InternalResource.loadString("geoline", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = pointMs.getCount();
        if (n < 2) {
            String string = InternalResource.loadString("pointMs", "GeoLine_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine.getType() != GeometryType.GEOLINE) {
            String string = InternalResource.loadString("geoline", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pointMs.getItem(i).getX();
            dArray2[i] = pointMs.getItem(i).getY();
            dArray3[i] = pointMs.getItem(i).getM();
        }
        long l = GeoLineMNative.jni_MakeLineM(geoLine.getHandle(), dArray, dArray2, dArray3);
        if (l != 0L) {
            GeoLineM geoLineM = (GeoLineM)Geometry.createInstance(l);
            InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
            return geoLineM;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoLine);
        return null;
    }

    @Deprecated
    public boolean updateM(Point2D fromPoint, Point2D toPoint, Double fromMeasure, Double toMeasure, Double tolerance, WhereToCalibrate whereToCalibrate, CalibrateMeasureMethod method) {
        CalibrateMode calibrateMode = CalibrateMode.BYDISTANCE;
        if (method == CalibrateMeasureMethod.BYMEASURE) {
            calibrateMode = CalibrateMode.BYMEASURE;
        }
        return this.updateM(fromPoint, toPoint, (double)fromMeasure, (double)toMeasure, (double)tolerance, whereToCalibrate, calibrateMode);
    }

    @Deprecated
    public boolean CalibrateLineM(PointMs pointMs, CalibrateMeasureMethod method, boolean isIgnoreGap) {
        CalibrateMode calibrateMode = CalibrateMode.BYDISTANCE;
        if (method == CalibrateMeasureMethod.BYMEASURE) {
            calibrateMode = CalibrateMode.BYMEASURE;
        }
        return this.calibrateLineM(pointMs, calibrateMode, isIgnoreGap);
    }

    @Deprecated
    public boolean calibrateLineM(GeoLineM geoLineM, CalibrateMeasureMethod method, boolean isIgnoreGap) {
        CalibrateMode calibrateMode = CalibrateMode.BYDISTANCE;
        if (method == CalibrateMeasureMethod.BYMEASURE) {
            calibrateMode = CalibrateMode.BYMEASURE;
        }
        return this.calibrateLineM(geoLineM, calibrateMode, isIgnoreGap);
    }

    @Deprecated
    public boolean interpolateM(Point2D fromPoint, Point2D toPoint, double fromMeasure, double toMeasure, double tolerance, CalibrateMeasureMethod method) {
        CalibrateMode calibrateMode = CalibrateMode.BYDISTANCE;
        if (method == CalibrateMeasureMethod.BYMEASURE) {
            calibrateMode = CalibrateMode.BYMEASURE;
        }
        return this.interpolateM(fromPoint, toPoint, fromMeasure, toMeasure, tolerance, calibrateMode);
    }

    @Deprecated
    public boolean extrapolateM(Point2D fromPoint, Point2D toPoint, double fromMeasure, double toMeasure, double tolerance, CalibrateMeasureMethod method) {
        CalibrateMode calibrateMode = CalibrateMode.BYDISTANCE;
        if (method == CalibrateMeasureMethod.BYMEASURE) {
            calibrateMode = CalibrateMode.BYMEASURE;
        }
        return this.extrapolateM(fromPoint, toPoint, fromMeasure, toMeasure, tolerance, calibrateMode);
    }
}

