/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BloodVolumeNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MarkPos;
import java.awt.Color;

public class BloodVolume
extends InternalHandleDisposable {
    public BloodVolume() {
        long l = BloodVolumeNative.jni_New();
        this.setHandle(l, true);
    }

    BloodVolume(long handle) {
        this.setHandle(handle, false);
    }

    public BloodVolume(BloodVolume bloodVolume) {
        if (bloodVolume == null) {
            String string = InternalResource.loadString("region3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bloodVolume.getHandle() == 0L) {
            String string = InternalResource.loadString("region3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = BloodVolumeNative.jni_Clone(bloodVolume.getHandle());
        super.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(bloodVolume);
    }

    public BloodVolume clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new BloodVolume(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            BloodVolumeNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public void setVolume(double volume) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVolume(double volume)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetVolume(this.getHandle(), volume);
    }

    public double getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return BloodVolumeNative.jni_GetVolume(this.getHandle());
    }

    public void setPosition(MarkPos position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPosition(MarkPos position)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetPosition(this.getHandle(), position.value());
    }

    public MarkPos getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPosition()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = BloodVolumeNative.jni_GetPosition(this.getHandle());
        return new MarkPos(n, n);
    }

    public void setWidth(double width) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(double width)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetWidth(this.getHandle(), width);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return BloodVolumeNative.jni_GetWidth(this.getHandle());
    }

    public void setHeight(double height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double height)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetHeight(this.getHandle(), height);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return BloodVolumeNative.jni_GetHeight(this.getHandle());
    }

    public void setOffsetX(double offsetX) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetX(double offsetX)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetOffsetX(this.getHandle(), offsetX);
    }

    public double getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return BloodVolumeNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetY(double offsetY) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetY(double offsetY)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetOffsetY(this.getHandle(), offsetY);
    }

    public double getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return BloodVolumeNative.jni_GetOffsetY(this.getHandle());
    }

    public void setVisible(boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible(boolean visible)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetVisible(this.getHandle(), visible);
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return BloodVolumeNative.jni_GetVisible(this.getHandle());
    }

    public void setLineWidth(double lineWidth) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineWidth(double lineWidth)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetLineWidth(this.getHandle(), lineWidth);
    }

    public double getLineWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return BloodVolumeNative.jni_GetLineWidth(this.getHandle());
    }

    public void setConsumeColor(Color consumeColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConsumeColor(Color consumeColor)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetConsumeColor(this.getHandle(), consumeColor.getRed(), consumeColor.getGreen(), consumeColor.getBlue(), consumeColor.getAlpha());
    }

    public Color getConsumeColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConsumeColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = BloodVolumeNative.jni_GetConsumeColor(this.getHandle());
        return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setRemainingColor(Color remainingColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRemainingColor(Color remainingColor)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetRemainingColor(this.getHandle(), remainingColor.getRed(), remainingColor.getGreen(), remainingColor.getBlue(), remainingColor.getAlpha());
    }

    public Color getRemainingColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRemainingColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = BloodVolumeNative.jni_GetRemainingColor(this.getHandle());
        return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setLineColor(Color lineColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineColor(Color lineColor)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        BloodVolumeNative.jni_SetLineColor(this.getHandle(), lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), lineColor.getAlpha());
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = BloodVolumeNative.jni_GetLineColor(this.getHandle());
        return new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
    }
}

