/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalMaterial;
import com.supermap.data.InternalResource;
import com.supermap.data.Material;
import com.supermap.data.StrokeType;
import com.supermap.data.SymbolMarkerStrokeNative;

public class SymbolMarkerStroke
extends InternalHandleDisposable {
    private Material a = null;

    public SymbolMarkerStroke(Geometry data) {
        if (data == null) {
            String string = InternalResource.loadString("data", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(data);
        if (l == 0L) {
            String string = InternalResource.loadString("data", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = SymbolMarkerStrokeNative.jni_New();
        this.setHandle(l2, true);
        data.makeSureNativeObjectLive();
    }

    SymbolMarkerStroke(long handle) {
        this.setHandle(handle, false);
    }

    public StrokeType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = SymbolMarkerStrokeNative.jni_GetType(this.getHandle());
        return (StrokeType)Enum.parseUGCValue(StrokeType.class, n);
    }

    public Material getMaterial() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMaterial()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null) {
            long l = SymbolMarkerStrokeNative.jni_GetMaterial(this.getHandle());
            Material material = InternalMaterial.createInstance(l);
            this.a = new Material(material, true);
            material.dispose();
        }
        return this.a;
    }

    public void setMaterial(Material value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaterial()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value.getHandle() == 0L) {
            String string = InternalResource.loadString("Material", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolMarkerStrokeNative.jni_SetMaterial(this.getHandle(), value.getHandle());
        this.a = new Material(value, true);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolMarkerStrokeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean isFillColorFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillColorFixed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolMarkerStrokeNative.jni_IsFillColorFixed(this.getHandle());
    }

    public void setFillColorFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillColorFixed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolMarkerStrokeNative.jni_SetFillColorFixed(this.getHandle(), value);
    }

    public boolean isLineColorFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillColorFixed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolMarkerStrokeNative.jni_IsLineColorFixed(this.getHandle());
    }

    public void setLineColorFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFillColorFixed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolMarkerStrokeNative.jni_SetLineColorFixed(this.getHandle(), value);
    }

    public double getTilingU() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilingU()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolMarkerStrokeNative.jni_GetTilingU(this.getHandle());
    }

    public void setTilingU(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTilingU()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolMarkerStrokeNative.jni_SetTilingU(this.getHandle(), value);
    }

    public double getTilingV() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilingV()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolMarkerStrokeNative.jni_GetTilingV(this.getHandle());
    }

    public void setTilingV(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTilingV()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolMarkerStrokeNative.jni_SetTilingV(this.getHandle(), value);
    }
}

