/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoLine;
import com.supermap.data.GeoMultiCurveNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class GeoMultiCurve
extends Geometry {
    public GeoMultiCurve() {
        long l = GeoMultiCurveNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoMultiCurve(GeoMultiCurve geoMCurve) {
        if (geoMCurve == null) {
            String string = InternalResource.loadString("GeoMultiCurve", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoMCurve);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoMultiCurve", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoMultiCurveNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoMCurve);
    }

    GeoMultiCurve(long handle) {
        this.setHandle(handle, false);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMultiCurveNative.jni_GetLength(this.getHandle());
    }

    public int getNumGeometries() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMultiCurveNative.jni_GetNumGeometries(this.getHandle());
    }

    public boolean addGeometry(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addGeometry()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == geometry) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoMultiCurveNative.jni_AddGeometry(this.getHandle(), geometry.getHandle());
    }

    public boolean removeGeometry(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemovePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoMultiCurveNative.jni_RemoveGeometry(this.getHandle(), index);
    }

    public Geometry getGeometry(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getGeometry(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getNumGeometries()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        long l = GeoMultiCurveNative.jni_GetGeometry(this.getHandle(), index);
        Geometry geometry = null;
        if (l != 0L) {
            geometry = GeoMultiCurve.createInstance(l);
        }
        return geometry;
    }

    public GeoLine convertToLine(int pointCountPerSegment) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoMultiCurveNative.jni_ConvertToLine(this.getHandle(), pointCountPerSegment);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoMultiCurveNative.jni_Clear(this.getHandle());
        this.clearHandle();
    }

    @Override
    public Geometry clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoMultiCurve(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoMultiCurveNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

