/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CSGNode;
import com.supermap.data.GeoConstructiveSolidNative;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalCSGNode;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoConstructiveSolid
extends Geometry3D {
    private ArrayList<CSGNode> a;

    public GeoConstructiveSolid() {
        this.setHandle(GeoConstructiveSolidNative.jni_New(), true);
        this.a = null;
    }

    public GeoConstructiveSolid(GeoConstructiveSolid geoConstructiveSolid) {
        if (geoConstructiveSolid.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoConstructiveSolid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoConstructiveSolidNative.jni_New1(geoConstructiveSolid.getHandle());
        super.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoConstructiveSolid);
    }

    GeoConstructiveSolid(long handle) {
        this.setHandle(handle, false);
    }

    public GeoConstructiveSolid(ArrayList<CSGNode> csgNodes) {
        if (csgNodes.size() <= 0) {
            String string = InternalResource.loadString("GeoConstructiveSolid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[csgNodes.size()];
        for (int i = 0; i < csgNodes.size(); ++i) {
            lArray[i] = csgNodes.get(i).getHandle();
        }
        long l = GeoConstructiveSolidNative.jni_New2(lArray);
        super.setHandle(l, true);
        this.a = csgNodes;
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoConstructiveSolidNative.jni_GetArea(this.getHandle());
    }

    @Override
    public double getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoConstructiveSolidNative.jni_GetVolume(this.getHandle());
    }

    public void setIsLonLat(boolean isLonLat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsLonLat", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoConstructiveSolidNative.jni_SetIsLonLat(this.getHandle(), isLonLat);
    }

    public boolean isLonLat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsLonLat", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoConstructiveSolidNative.jni_GetIsLonLat(this.getHandle());
    }

    public void setCSGNodes(ArrayList<CSGNode> csgNodes) {
        if (csgNodes.size() <= 0) {
            String string = InternalResource.loadString("setCSGNodes", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[csgNodes.size()];
        for (int i = 0; i < csgNodes.size(); ++i) {
            lArray[i] = csgNodes.get(i).getHandle();
        }
        this.a = csgNodes;
        GeoConstructiveSolidNative.jni_SetCSGNodes(this.getHandle(), lArray);
    }

    public ArrayList<CSGNode> getCSGNodes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCSGNodes", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = GeoConstructiveSolidNative.jni_GetCSGNodes(this.getHandle());
        this.a.clear();
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            this.a.add(InternalCSGNode.createInstance(lArray[i]));
            InternalHandleDisposable.setIsDisposable(this.a.get(i), false);
        }
        return this.a;
    }

    public GeoModel3D convertToGeoModel3D(int nResolution, int nFragmentSize, int nFragmentAngle) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToGeoModel3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoConstructiveSolidNative.jni_ConvertToGeoModel3D(this.getHandle(), nResolution, nFragmentSize, nFragmentAngle);
        return new GeoModel3D(l);
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToRegion", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoConstructiveSolidNative.jni_ConvertToRegion(this.getHandle());
        return new GeoRegion(l);
    }

    @Override
    protected void finalize() {
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoConstructiveSolidNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this.a.clear();
        }
    }

    @Override
    public GeoConstructiveSolid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoConstructiveSolid(this);
    }
}

