/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoBoxNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Size2D;

public class GeoBox
extends Geometry3D {
    public GeoBox() {
        long l = GeoBoxNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoBox(GeoBox geoBox) {
        if (geoBox == null) {
            String string = InternalResource.loadString("geoBox", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoBox);
        if (l == 0L) {
            String string = InternalResource.loadString("geoBox", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoBoxNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoBox);
    }

    public GeoBox(Point3D position, Size2D bottomSize, double height) {
        if (bottomSize.getWidth() <= 0.0) {
            String string = InternalResource.loadString("length", "GeoBox_LengthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bottomSize.getHeight() <= 0.0) {
            String string = InternalResource.loadString("width", "GeoBox_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (height <= 0.0) {
            String string = InternalResource.loadString("height", "GeoBox_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoBoxNative.jni_New1(position.getX(), position.getY(), position.getZ(), bottomSize.getWidth(), bottomSize.getHeight(), height);
        this.setHandle(l, true);
    }

    GeoBox(long handle) {
        this.setHandle(handle, false);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        GeoBoxNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoBoxNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoBox_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBoxNative.jni_SetHeight(this.getHandle(), value);
    }

    public Size2D getBottomSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoBoxNative.jni_getBottomSize(this.getHandle());
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setBottomSize(Size2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetLength(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value.getWidth() <= 0.0) {
            String string = InternalResource.loadString("value", "GeoBox_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (value.getHeight() <= 0.0) {
            String string = InternalResource.loadString("value", "GeoBox_LengthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBoxNative.jni_setBottomSize(this.getHandle(), value.getWidth(), value.getHeight());
    }

    @Override
    public GeoBox clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoBox(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoBoxNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

