/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.CityGMLFeatureSealNative;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.TextureWrapMode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CityGMLFeatureSeal
extends InternalHandleDisposable {
    public CityGMLFeatureSeal() {
        long l = CityGMLFeatureSealNative.jni_New();
        this.setHandle(l, true);
    }

    CityGMLFeatureSeal(long handle) {
        CityGMLFeatureSeal.a(handle, "CityGMLFeatureSeal");
        this.setHandle(handle, false);
    }

    public void setID(String id) {
        CityGMLFeatureSeal.a(this.getHandle(), "setID");
        CityGMLFeatureSealNative.jni_SetID(this.getHandle(), id);
    }

    public String getID() {
        CityGMLFeatureSeal.a(this.getHandle(), "getID");
        return CityGMLFeatureSealNative.jni_GetID(this.getHandle());
    }

    public void setEpsgCode(int code) {
        CityGMLFeatureSeal.a(this.getHandle(), "setEpsgCode");
        CityGMLFeatureSealNative.jni_SetEpsgCode(this.getHandle(), code);
    }

    public void setExteriorRing(Point3Ds ring) {
        CityGMLFeatureSeal.a(this.getHandle(), "setExteriorRing");
        if (ring != null && ring.getCount() > 0) {
            int n = ring.getCount();
            double[] dArray = new double[n * 3];
            for (int i = 0; i < n; ++i) {
                dArray[3 * i] = ring.getItem((int)i).x;
                dArray[3 * i + 1] = ring.getItem((int)i).y;
                dArray[3 * i + 2] = ring.getItem((int)i).z;
            }
            CityGMLFeatureSealNative.jni_SetExteriorRing(this.getHandle(), dArray);
        }
    }

    public Point3Ds getExteriorRing() {
        CityGMLFeatureSeal.a(this.getHandle(), "getExteriorRing");
        Point3Ds point3Ds = new Point3Ds();
        double[] dArray = CityGMLFeatureSealNative.jni_GetExteriorRing(this.getHandle());
        for (int i = 0; i < dArray.length / 3; ++i) {
            Point3D point3D = new Point3D();
            point3D.x = dArray[3 * i];
            point3D.y = dArray[3 * i + 1];
            point3D.z = dArray[3 * i + 2];
            point3Ds.add(point3D);
        }
        return point3Ds;
    }

    public void setExteriorRingID(String ringID) {
        CityGMLFeatureSeal.a(this.getHandle(), "setExteriorRingID");
        CityGMLFeatureSealNative.jni_SetExteriorRingID(this.getHandle(), ringID);
    }

    public String getExteriorRingID() {
        CityGMLFeatureSeal.a(this.getHandle(), "getExteriorRingID");
        return CityGMLFeatureSealNative.jni_GetExteriorRingID(this.getHandle());
    }

    public void setExteriorTextureCoord(Point3Ds textureCoord) {
        CityGMLFeatureSeal.a(this.getHandle(), "setExteriorTextureCoord");
        if (textureCoord != null && textureCoord.getCount() > 0) {
            int n = textureCoord.getCount();
            double[] dArray = new double[n * 3];
            for (int i = 0; i < n; ++i) {
                dArray[3 * i] = textureCoord.getItem((int)i).x;
                dArray[3 * i + 1] = textureCoord.getItem((int)i).y;
                dArray[3 * i + 2] = textureCoord.getItem((int)i).z;
            }
            CityGMLFeatureSealNative.jni_SetExteriorTextureCoord(this.getHandle(), dArray);
        }
    }

    public Point3Ds getExteriorTextureCoord() {
        CityGMLFeatureSeal.a(this.getHandle(), "getExteriorTextureCoord");
        Point3Ds point3Ds = new Point3Ds();
        double[] dArray = CityGMLFeatureSealNative.jni_GetExteriorTextureCoord(this.getHandle());
        for (int i = 0; i < dArray.length / 3; ++i) {
            Point3D point3D = new Point3D();
            point3D.x = dArray[3 * i];
            point3D.y = dArray[3 * i + 1];
            point3D.z = dArray[3 * i + 2];
            point3Ds.add(point3D);
        }
        return point3Ds;
    }

    public void setInteriorRings(List<Point3Ds> ringList) {
        CityGMLFeatureSeal.a(this.getHandle(), "setInteriorRings");
        if (ringList != null && !ringList.isEmpty()) {
            int n = ringList.size();
            double[][] dArrayArray = new double[n][];
            for (int i = 0; i < n; ++i) {
                Point3Ds point3Ds = ringList.get(i);
                int n2 = point3Ds.getCount();
                dArrayArray[i] = new double[n2 * 3];
                for (int j = 0; j < n2; ++j) {
                    dArrayArray[i][3 * j] = point3Ds.getItem((int)j).x;
                    dArrayArray[i][3 * j + 1] = point3Ds.getItem((int)j).y;
                    dArrayArray[i][3 * j + 2] = point3Ds.getItem((int)j).z;
                }
            }
            CityGMLFeatureSealNative.jni_SetInteriorRings(this.getHandle(), dArrayArray);
        }
    }

    public List<Point3Ds> getInteriorRings() {
        CityGMLFeatureSeal.a(this.getHandle(), "getInteriorRings");
        ArrayList<Point3Ds> arrayList = new ArrayList<Point3Ds>();
        double[][] dArray = CityGMLFeatureSealNative.jni_GetInteriorRings(this.getHandle());
        for (int i = 0; i < dArray.length; ++i) {
            Point3Ds point3Ds = new Point3Ds();
            for (int j = 0; j < dArray[i].length / 3; ++j) {
                Point3D point3D = new Point3D();
                point3D.x = dArray[i][3 * j];
                point3D.y = dArray[i][3 * j + 1];
                point3D.z = dArray[i][3 * j + 2];
                point3Ds.add(point3D);
            }
            arrayList.add(point3Ds);
        }
        return arrayList;
    }

    public void setInteriorRingIDs(List<String> ringIDList) {
        CityGMLFeatureSeal.a(this.getHandle(), "setInteriorRingIDs");
        String[] stringArray = ringIDList.toArray(new String[ringIDList.size()]);
        CityGMLFeatureSealNative.jni_SetInteriorRingIDs(this.getHandle(), stringArray);
    }

    public List<String> getInteriorRingIDs() {
        CityGMLFeatureSeal.a(this.getHandle(), "getInteriorRingIDs");
        String[] stringArray = CityGMLFeatureSealNative.jni_GetInteriorRingIDs(this.getHandle());
        if (stringArray != null) {
            return Arrays.asList(stringArray);
        }
        return null;
    }

    public void setInteriorTextureCoords(List<Point3Ds> textureCoordList) {
        CityGMLFeatureSeal.a(this.getHandle(), "setInteriorTextureCoords");
        if (textureCoordList != null && !textureCoordList.isEmpty()) {
            int n = textureCoordList.size();
            double[][] dArrayArray = new double[n][];
            for (int i = 0; i < n; ++i) {
                Point3Ds point3Ds = textureCoordList.get(i);
                int n2 = point3Ds.getCount();
                dArrayArray[i] = new double[n2 * 3];
                for (int j = 0; j < n2; ++j) {
                    dArrayArray[i][3 * j] = point3Ds.getItem((int)j).x;
                    dArrayArray[i][3 * j + 1] = point3Ds.getItem((int)j).y;
                    dArrayArray[i][3 * j + 2] = point3Ds.getItem((int)j).z;
                }
            }
            CityGMLFeatureSealNative.jni_SetInteriorTextureCoords(this.getHandle(), dArrayArray);
        }
    }

    public List<Point3Ds> getInteriorTextureCoords() {
        CityGMLFeatureSeal.a(this.getHandle(), "getInteriorTextureCoords");
        ArrayList<Point3Ds> arrayList = new ArrayList<Point3Ds>();
        double[][] dArray = CityGMLFeatureSealNative.jni_GetInteriorTextureCoords(this.getHandle());
        for (int i = 0; i < dArray.length; ++i) {
            Point3Ds point3Ds = new Point3Ds();
            for (int j = 0; j < dArray[i].length / 3; ++j) {
                Point3D point3D = new Point3D();
                point3D.x = dArray[i][3 * j];
                point3D.y = dArray[i][3 * j + 1];
                point3D.z = dArray[i][3 * j + 2];
                point3Ds.add(point3D);
            }
            arrayList.add(point3Ds);
        }
        return arrayList;
    }

    public boolean isVisible() {
        CityGMLFeatureSeal.a(this.getHandle(), "isVisible");
        return CityGMLFeatureSealNative.jni_IsVisible(this.getHandle());
    }

    public void setVisible(boolean isVisible) {
        CityGMLFeatureSeal.a(this.getHandle(), "setVisible");
        CityGMLFeatureSealNative.jni_SetVisible(this.getHandle(), isVisible);
    }

    public void setFilePath(String path) {
        CityGMLFeatureSeal.a(this.getHandle(), "setFilePath");
        CityGMLFeatureSealNative.jni_SetFilePath(this.getHandle(), path);
    }

    public String getFilePath() {
        CityGMLFeatureSeal.a(this.getHandle(), "getFilePath");
        return CityGMLFeatureSealNative.jni_GetFilePath(this.getHandle());
    }

    public void setImagePath(String path) {
        CityGMLFeatureSeal.a(this.getHandle(), "setImagePath");
        CityGMLFeatureSealNative.jni_SetImageURI(this.getHandle(), path);
    }

    public String getImagePath() {
        CityGMLFeatureSeal.a(this.getHandle(), "getImagePath");
        return CityGMLFeatureSealNative.jni_GetImageURI(this.getHandle());
    }

    public void setTextureWrapMode(TextureWrapMode mode) {
        CityGMLFeatureSeal.a(this.getHandle(), "setTextureWrapMode");
        CityGMLFeatureSealNative.jni_SetTexAddressingMode(this.getHandle(), mode.value());
    }

    public TextureWrapMode getTextureWrapMode() {
        CityGMLFeatureSeal.a(this.getHandle(), "getTextureWrapMode");
        int n = CityGMLFeatureSealNative.jni_GetTexAddressingMode(this.getHandle());
        return (TextureWrapMode)Enum.parseUGCValue(TextureWrapMode.class, n);
    }

    public void setDiffuseColor(Color value) {
        CityGMLFeatureSeal.a(this.getHandle(), "setDiffuseColor");
        CityGMLFeatureSealNative.jni_SetDiffuseColor(this.getHandle(), value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
    }

    public Color getDiffuseColor() {
        CityGMLFeatureSeal.a(this.getHandle(), "getDiffuseColor");
        int[] nArray = CityGMLFeatureSealNative.jni_GetDiffuseColor(this.getHandle());
        Color color = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        return color;
    }

    @Override
    public void dispose() {
    }

    protected static CityGMLFeatureSeal createInstance(long handle) {
        CityGMLFeatureSeal.a(handle, "createInstance");
        return new CityGMLFeatureSeal(handle);
    }

    private static void a(long l, String string) {
        if (l == 0L) {
            String string2 = InternalResource.loadString(string, "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
    }
}

