/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point3D;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingModelXNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.a;

public class ImportSettingModelX
extends ImportSetting {
    public ImportSettingModelX() {
        long l = ImportSettingModelXNative.jni_New();
        this.setHandle(l, true);
        super.a(com.supermap.data.conversion.a.a);
    }

    public ImportSettingModelX(ImportSettingModelX importSettingModelX) {
        if (importSettingModelX == null) {
            String string = InternalResource.loadString("importSettingModelX", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingModelX);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingModelX", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingModelXNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingModelX.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingModelX.getTargetDatasource());
        super.a(com.supermap.data.conversion.a.a);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingModelX));
    }

    public ImportSettingModelX(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public ImportSettingModelX(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingModelXNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public void setPosition(Point3D pntPosition) {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingModelXNative.jni_SetPosition(this.getHandle(), pntPosition.getX(), pntPosition.getY(), pntPosition.getZ());
        }
    }

    public Point3D getPosition() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        double[] dArray = ImportSettingModelXNative.jni_GetPosition(this.getHandle());
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        return point3D;
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingModelXNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingModelXNative.jni_SetImportingAsCAD(this.getHandle(), value);
    }
}

