/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.data.DatasetGrid;
import java.util.ArrayList;
import java.util.Map;

public class MCECellularAutomataParameter {
    private ArrayList[] b;
    private int c;
    private double d;
    private double e;
    private Map<Integer, Boolean> f;
    private int g;
    private boolean h;
    private DatasetGrid i;
    CellularAutomataParameter a;

    public MCECellularAutomataParameter() {
        this.c = 2;
        this.d = 0.5;
        this.e = 0.5;
        this.f = null;
        this.h = false;
        this.i = null;
        this.a = null;
    }

    public MCECellularAutomataParameter(MCECellularAutomataParameter para) {
        this.b = para.b;
        this.c = para.c;
        this.d = para.d;
        this.e = para.e;
        this.f = para.f;
        this.g = para.g;
        this.h = para.h;
        this.i = para.i;
        if (this.a == null) {
            this.a = new CellularAutomataParameter();
        }
        this.a.Reset(para.a);
    }

    public CellularAutomataParameter getCellularAutomataParameter() {
        return this.a;
    }

    public void setCellularAutomataParameter(CellularAutomataParameter value) {
        if (value == null) {
            String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.a == null) {
            this.a = new CellularAutomataParameter();
        }
        this.a.Reset(value);
    }

    public boolean isCheckResult() {
        return this.h;
    }

    public void setCheckResult(boolean value) {
        this.h = value;
    }

    public DatasetGrid getEndCellGrid() {
        return this.i;
    }

    public void setEndCellGrid(DatasetGrid value) {
        if (value == null) {
            String string = InternalResourceSpatialanalyst.loadString("EndCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.i = value;
    }

    public double[][] getAHPComparisonMatrix() {
        if (this.b == null) {
            return null;
        }
        int n = this.b.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n];
            for (int j = 0; j < n; ++j) {
                dArray[j] = (Double)this.b[i].get(j);
            }
            dArrayArray[i] = dArray;
        }
        return dArrayArray;
    }

    public void setAHPComparisonMatrix(double[][] value) {
        int n;
        int n2;
        if (value == null || value.length == 0) {
            String string = InternalResourceSpatialanalyst.loadString("AHPComparisonMatrix", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < value.length; ++n2) {
            if (value[n2] == null) {
                String string = InternalResourceSpatialanalyst.loadString("AHPComparisonMatrix[" + n2 + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (value.length == value[n2].length) continue;
            String string = InternalResourceSpatialanalyst.loadString("AHPComparisonMatrix[" + n2 + "].length and AHPComparisonMatrix.length must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = value.length;
        if (this.b != null) {
            for (n = 0; n < this.b.length; ++n) {
                this.b[n].clear();
            }
        } else {
            this.b = new ArrayList[n2];
            for (n = 0; n < n2; ++n) {
                this.b[n] = new ArrayList();
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                this.b[n].add(value[n][i]);
            }
        }
    }

    public double getGlobalValue() {
        return this.d;
    }

    public void setGlobalValue(double value) {
        if (value <= 0.0 || value >= 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("GlobalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.d = value;
    }

    public double getLocalValue() {
        return this.e;
    }

    public void setLocalValue(double value) {
        if (value <= 0.0 || value >= 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("LocalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.e = value;
    }

    public int getAlpha() {
        return this.c;
    }

    public void setAlpha(int value) {
        if (value <= 0 || value > 10) {
            String string = InternalResourceSpatialanalyst.loadString("Alpha", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.c = value;
    }

    public Map<Integer, Boolean> getConversionRules() {
        return this.f;
    }

    public void setConversionRules(Map<Integer, Boolean> value) {
        if (value == null || value.size() == 0) {
            String string = InternalResourceSpatialanalyst.loadString("ConversionRules", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (Integer n : value.keySet()) {
            if (n != null && value.get(n) != null) continue;
            String string = InternalResourceSpatialanalyst.loadString("ConversionRules key or value", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.f = value;
    }

    public int getConversionTarget() {
        return this.g;
    }

    public void setConversionTarget(int value) {
        this.g = value;
    }
}

