/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.AggregationType;
import com.supermap.analyst.spatialanalyst.BoundaryCleanSortType;
import com.supermap.analyst.spatialanalyst.DissolveParameter;
import com.supermap.analyst.spatialanalyst.EliminateMode;
import com.supermap.analyst.spatialanalyst.GeneralizeAnalystNative;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetImage;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.MajorityDefinition;
import com.supermap.analyst.spatialanalyst.NeighborNumber;
import com.supermap.analyst.spatialanalyst.ReclassMappingTable;
import com.supermap.analyst.spatialanalyst.ReclassPixelFormat;
import com.supermap.analyst.spatialanalyst.ReclassSegment;
import com.supermap.analyst.spatialanalyst.ReclassType;
import com.supermap.analyst.spatialanalyst.RegionGroupResult;
import com.supermap.analyst.spatialanalyst.ResampleMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;

public class GeneralizeAnalyst {
    private static License a;
    private static transient Vector b;
    private static GridAnalystSetting c;

    private GeneralizeAnalyst() {
        c = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return c;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new GridAnalystSetting();
        }
        c.setBounds(gridAnalystSetting.getBounds());
        c.setBoundsType(gridAnalystSetting.getBoundsType());
        c.setCellSizeType(gridAnalystSetting.getCellSizeType());
        c.setCellSize(gridAnalystSetting.getCellSize());
        c.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(gridAnalystSetting.getValidRegion());
        c.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid aggregate(DatasetGrid sourceDataset, int scale, AggregationType aggregationType, boolean isExpanded, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName) {
        return GeneralizeAnalyst.aggregate(sourceDataset, scale, aggregationType, isExpanded, isIgnoreNoValue, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid aggregate(DatasetGrid sourceDataset, int scale, AggregationType aggregationType, boolean isExpanded, boolean isIgnoreNoValue, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(aggregationType);
            long l3 = GeneralizeAnalystNative.jni_New();
            if (null != c) {
                GeneralizeAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
                Rectangle2D rectangle2D = c.getBounds();
                GeneralizeAnalystNative.jni_SetTargetBounds(l3, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l4 = GeneralizeAnalystNative.jni_Aggregate(l3, l, scale, n, isExpanded, isIgnoreNoValue, l2, targetDatasetName);
            GeneralizeAnalystNative.jni_Delete(l3);
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static Dataset resample(Dataset sourceDataset, double newCellSize, ResampleMode resampleMode, Datasource targetDatasource, String targetDatasetName) {
        return GeneralizeAnalyst.resample(sourceDataset, newCellSize, resampleMode, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset resample(Dataset sourceDataset, double newCellSize, ResampleMode resampleMode, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(resampleMode);
            long l3 = GeneralizeAnalystNative.jni_New();
            if (null != c) {
                GeneralizeAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
                Rectangle2D rectangle2D = c.getBounds();
                GeneralizeAnalystNative.jni_SetTargetBounds(l3, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l4 = GeneralizeAnalystNative.jni_Resample(l3, l, newCellSize, n, l2, targetDatasetName);
            GeneralizeAnalystNative.jni_Delete(l3);
            if (l4 != 0L) {
                if (sourceDataset.getType() == DatasetType.IMAGE) {
                    DatasetImage datasetImage = InternalDatasetImage.createInstance(l4, targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                    DatasetImage datasetImage2 = datasetImage;
                    return datasetImage2;
                }
                DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                DatasetGrid datasetGrid2 = datasetGrid;
                return datasetGrid2;
            }
            Dataset dataset = null;
            return dataset;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset equantResample(Dataset sourceDataset, int equantNumber, ResampleMode resampleMode, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (equantNumber <= 1) {
                String string = InternalResourceSpatialanalyst.loadString("equantNumber", "Must_Larger_Than_One", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(resampleMode);
            long l3 = GeneralizeAnalystNative.jni_New();
            if (null != c) {
                GeneralizeAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
                Rectangle2D rectangle2D = c.getBounds();
                GeneralizeAnalystNative.jni_SetTargetBounds(l3, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l4 = GeneralizeAnalystNative.jni_EquantResample(l3, l, equantNumber, n, l2, targetDatasetName);
            GeneralizeAnalystNative.jni_Delete(l3);
            if (l4 != 0L) {
                if (sourceDataset.getType() == DatasetType.IMAGE) {
                    DatasetImage datasetImage = InternalDatasetImage.createInstance(l4, targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetImage);
                    DatasetImage datasetImage2 = datasetImage;
                    return datasetImage2;
                }
                DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                DatasetGrid datasetGrid2 = datasetGrid;
                return datasetGrid2;
            }
            Dataset dataset = null;
            return dataset;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid reclass(DatasetGrid sourceDataset, ReclassMappingTable reclassMappingTable, ReclassPixelFormat reclassPixelFormat, Datasource targetDatasource, String targetDatasetName) {
        return GeneralizeAnalyst.reclass(sourceDataset, reclassMappingTable, reclassPixelFormat, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid reclass(DatasetGrid sourceDataset, ReclassMappingTable reclassMappingTable, ReclassPixelFormat reclassPixelFormat, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (reclassMappingTable == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)reclassMappingTable) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("reclassMappingTable", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (reclassMappingTable.getSegmentCount() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("reclassMappingTable segments count", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            if (reclassMappingTable.getReclassType() == ReclassType.RANGE) {
                ReclassSegment[] reclassSegmentArray = reclassMappingTable.getSegments();
                for (int i = 0; i < reclassSegmentArray.length; ++i) {
                    if (!(reclassSegmentArray[i].getStartValue() > reclassSegmentArray[i].getEndValue())) continue;
                    String string = InternalResourceSpatialanalyst.loadString("Segments[" + i + "]:EndValue < StartValue", "ArgumentInvalid", "spatialanalyst_resources");
                    throw new IllegalStateException(string);
                }
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)reclassMappingTable);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(reclassPixelFormat);
            long l4 = GeneralizeAnalystNative.jni_New();
            if (null != c) {
                GeneralizeAnalystNative.jni_SetShowProgress(l4, c.isShowProgress());
                Rectangle2D rectangle2D = c.getBounds();
                GeneralizeAnalystNative.jni_SetTargetBounds(l4, c.getBoundsType().value(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
            }
            long l5 = GeneralizeAnalystNative.jni_Reclass(l4, l, l2, n, l3, targetDatasetName);
            GeneralizeAnalystNative.jni_Delete(l4);
            DatasetGrid datasetGrid = null;
            if (l5 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)reclassMappingTable));
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid replace(DatasetGrid sourceDataset, Map<Double, Double> replaceTable, Datasource targetDatasource, String targetDatasetName) {
        return GeneralizeAnalyst.replace(sourceDataset, replaceTable, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid replace(DatasetGrid sourceDataset, Map<Double, Double> replaceTable, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (replaceTable == null || replaceTable.size() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("replaceTable", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            Object[] objectArray = replaceTable.keySet().toArray();
            int n = objectArray.length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = (Double)objectArray[i];
                dArray2[i] = replaceTable.get(dArray[i]);
            }
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = GeneralizeAnalystNative.jni_New();
            if (null != c) {
                GeneralizeAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
            }
            long l4 = GeneralizeAnalystNative.jni_Replace(l3, l, dArray, dArray2, l2, targetDatasetName);
            GeneralizeAnalystNative.jni_Delete(l3);
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid slice(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, int numberZones, int baseOutputZones) {
        return GeneralizeAnalyst.slice(sourceDataset, targetDatasource, targetDatasetName, numberZones, baseOutputZones, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid slice(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, int numberZones, int baseOutputZones, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (numberZones < 2) {
                String string = InternalResourceSpatialanalyst.loadString("numberZones", "Must_Larger_Than_One", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("numberZones", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = GeneralizeAnalystNative.jni_Slice(l, l2, targetDatasetName, numberZones, baseOutputZones);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    @Deprecated
    public static double[] ComputeRange(DatasetGrid sourceDataset, int count) {
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (count < 1) {
            String string = InternalResourceSpatialanalyst.loadString("count", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        double[] dArray = GeneralizeAnalystNative.jni_ComputeRange(l, count);
        return dArray;
    }

    @Deprecated
    public static double[] ComputeRange(DatasetVector sourceDataset, String field, int count) {
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (count < 1) {
            String string = InternalResourceSpatialanalyst.loadString("count", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        double[] dArray = GeneralizeAnalystNative.jni_ComputeRange1(l, field, count);
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "GeneralizeAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    @Deprecated
    public static DatasetVector dissolve(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, DissolveParameter dissolveParameter) {
        GeneralizeAnalyst.a();
        if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (dissolveParameter == null) {
            String string = InternalResourceSpatialanalyst.loadString("dissolveParameter", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
        long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)dissolveParameter);
        long l4 = GeneralizeAnalystNative.jni_Dissolve(l, l2, targetDatasetName, l3);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dissolveParameter));
        return datasetVector;
    }

    @Deprecated
    public static boolean eliminate(DatasetVector sourceDatasetVector, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion) {
        if (sourceDatasetVector == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionTolerance < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (vertexTolerance < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eliminateMode == null) {
            String string = InternalResourceSpatialanalyst.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDatasetVector);
        boolean bl = false;
        bl = GeneralizeAnalystNative.jni_Eliminate(l, regionTolerance, vertexTolerance, eliminateMode.value(), isDeleteSingleRegion);
        return bl;
    }

    public static DatasetGrid majorityFilter(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, MajorityDefinition majorityDefinition) {
        return GeneralizeAnalyst.majorityFilter(sourceDataset, targetDatasource, targetDatasetName, neighborNumber, majorityDefinition, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid majorityFilter(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, MajorityDefinition majorityDefinition, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = GeneralizeAnalystNative.jni_MajorityFilter(l, l2, targetDatasetName, InternalEnum.getUGCValue(neighborNumber), InternalEnum.getUGCValue(majorityDefinition));
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid expand(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber method, int cellNumber, int[] zoneValues) {
        return GeneralizeAnalyst.expand(sourceDataset, targetDatasource, targetDatasetName, method, cellNumber, zoneValues, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid expand(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber method, int cellNumber, int[] zoneValues, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (zoneValues == null || zoneValues.length < 1) {
                String string = InternalResourceSpatialanalyst.loadString("zoneValues", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = GeneralizeAnalystNative.jni_Expand(l, l2, targetDatasetName, InternalEnum.getUGCValue(method), cellNumber, zoneValues);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid shrink(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber method, int cellNumber, int[] zoneValues) {
        return GeneralizeAnalyst.shrink(sourceDataset, targetDatasource, targetDatasetName, method, cellNumber, zoneValues, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid shrink(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber method, int cellNumber, int[] zoneValues, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (zoneValues == null || zoneValues.length < 1) {
                String string = InternalResourceSpatialanalyst.loadString("zoneValues", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = GeneralizeAnalystNative.jni_Shrink(l, l2, targetDatasetName, InternalEnum.getUGCValue(method), cellNumber, zoneValues);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static RegionGroupResult regionGroup(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, boolean isSaveLinkValue, boolean isLinkByNeighbor, int excludedValue) {
        return GeneralizeAnalyst.regionGroup(sourceDataset, targetDatasource, targetDatasetName, neighborNumber, isSaveLinkValue, isLinkByNeighbor, excludedValue, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionGroupResult regionGroup(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, boolean isSaveLinkValue, boolean isLinkByNeighbor, int excludedValue, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int[] nArray = new int[]{excludedValue};
            long[] lArray = GeneralizeAnalystNative.jni_RegionGroup(l, l2, targetDatasetName, InternalEnum.getUGCValue(neighborNumber), isSaveLinkValue, isLinkByNeighbor, nArray);
            DatasetGrid datasetGrid = null;
            DatasetVector datasetVector = null;
            RegionGroupResult regionGroupResult = null;
            if (lArray != null && lArray.length == 2) {
                if (lArray[0] != 0L) {
                    datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                }
                if (lArray[1] != 0L) {
                    datasetVector = InternalDatasetVector.createInstance(lArray[1], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
                }
            }
            RegionGroupResult regionGroupResult2 = regionGroupResult = new RegionGroupResult(datasetGrid, datasetVector);
            return regionGroupResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static RegionGroupResult regionGroup(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, boolean isSaveLinkValue) {
        return GeneralizeAnalyst.regionGroup(sourceDataset, targetDatasource, targetDatasetName, neighborNumber, isSaveLinkValue, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionGroupResult regionGroup(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, NeighborNumber neighborNumber, boolean isSaveLinkValue, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int[] nArray = new int[]{};
            long[] lArray = GeneralizeAnalystNative.jni_RegionGroup(l, l2, targetDatasetName, InternalEnum.getUGCValue(neighborNumber), isSaveLinkValue, true, nArray);
            DatasetGrid datasetGrid = null;
            DatasetVector datasetVector = null;
            RegionGroupResult regionGroupResult = null;
            if (lArray != null && lArray.length == 2) {
                if (lArray[0] != 0L) {
                    datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                }
                if (lArray[1] != 0L) {
                    datasetVector = InternalDatasetVector.createInstance(lArray[1], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
                }
            }
            RegionGroupResult regionGroupResult2 = regionGroupResult = new RegionGroupResult(datasetGrid, datasetVector);
            return regionGroupResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid nibble(DatasetGrid sourceDataset, DatasetGrid maskDataset, DatasetGrid zoneDataset, Datasource targetDatasource, String targetDatasetName, boolean isMaskNoValue, boolean isNibbleNoValue) {
        return GeneralizeAnalyst.nibble(sourceDataset, maskDataset, zoneDataset, targetDatasource, targetDatasetName, isMaskNoValue, isNibbleNoValue, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid nibble(DatasetGrid sourceDataset, DatasetGrid maskDataset, DatasetGrid zoneDataset, Datasource targetDatasource, String targetDatasetName, boolean isMaskNoValue, boolean isNibbleNoValue, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (maskDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)maskDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("maskDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)maskDataset);
            long l4 = 0L;
            if (zoneDataset != null && InternalHandleSpatialanalyst.getHandle((InternalHandle)zoneDataset) != 0L) {
                l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)zoneDataset);
            }
            long l5 = GeneralizeAnalystNative.jni_Nibble(l, l3, l4, l2, targetDatasetName, isMaskNoValue, isNibbleNoValue);
            DatasetGrid datasetGrid = null;
            if (l5 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l5, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid boundaryClean(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, BoundaryCleanSortType sortType, boolean isRunTwoTimes) {
        return GeneralizeAnalyst.boundaryClean(sourceDataset, targetDatasource, targetDatasetName, sortType, isRunTwoTimes, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid boundaryClean(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, BoundaryCleanSortType sortType, boolean isRunTwoTimes, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset.getPixelFormat() != PixelFormat.BIT8 && sourceDataset.getPixelFormat() != PixelFormat.BIT16 && sourceDataset.getPixelFormat() != PixelFormat.BIT32 && sourceDataset.getPixelFormat() != PixelFormat.BIT64 && sourceDataset.getPixelFormat() != PixelFormat.UBIT1 && sourceDataset.getPixelFormat() != PixelFormat.UBIT4 && sourceDataset.getPixelFormat() != PixelFormat.UBIT8 && sourceDataset.getPixelFormat() != PixelFormat.UBIT16 && sourceDataset.getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "ZonalDataset_UnsupportedPixelType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = GeneralizeAnalystNative.jni_BoundaryClean(l, l2, targetDatasetName, InternalEnum.getUGCValue(sortType), isRunTwoTimes);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid thin(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, long backOrNoValue) {
        return GeneralizeAnalyst.thin(sourceDataset, targetDatasource, targetDatasetName, backOrNoValue, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid thin(DatasetGrid sourceDataset, Datasource targetDatasource, String targetDatasetName, long backOrNoValue, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            GeneralizeAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l3 = GeneralizeAnalystNative.jni_ThinRasterBinary(l2, l, targetDatasetName, backOrNoValue, true);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

