/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.SmoothMethod;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;

public class DistanceAnalystParameter {
    private double a;
    private double b;
    private Dataset c;
    private DatasetGrid d;
    private DatasetGrid e;
    private Datasource f;
    private Datasource g;
    private Datasource h;
    private Datasource i;
    private String j;
    private String k;
    private String l;
    private DatasetVector m;
    private double n;
    private double o;
    private SmoothMethod p;
    private int q;

    public DistanceAnalystParameter() {
        this.a = -1.0;
        this.b = 0.0;
        this.c = null;
        this.d = null;
        this.e = null;
        this.g = null;
        this.f = null;
        this.h = null;
        this.j = null;
        this.k = null;
        this.l = null;
        this.i = null;
        this.n = 90.0;
        this.o = 90.0;
        this.p = SmoothMethod.NONE;
        this.q = 0;
        this.m = null;
    }

    public DistanceAnalystParameter(DistanceAnalystParameter parameter) {
        this.a = parameter.getMaxDistance();
        this.b = parameter.getCellSize();
        this.c = parameter.getSourceDataset();
        this.d = parameter.getCostGrid();
        this.j = parameter.getDistanceGridName();
        this.k = parameter.getDirectionGridName();
        this.l = parameter.getAllocationGridName();
        this.i = parameter.getTargetDatasource();
        this.m = parameter.getBarrierRegion();
        this.n = parameter.getMaxUpslopeDegree();
        this.o = parameter.getMaxDownslopeDegree();
        this.p = parameter.getPathLineSmoothMethod();
        this.q = parameter.getPathLineSmoothDegree();
    }

    public double getMaxDistance() {
        return this.a;
    }

    public void setMaxDistance(double maxDistance) {
        this.a = maxDistance;
    }

    public double getCellSize() {
        return this.b;
    }

    public void setCellSize(double cellSize) {
        this.b = cellSize;
    }

    public Dataset getSourceDataset() {
        return this.c;
    }

    public void setSourceDataset(Dataset sourceDataset) {
        this.c = sourceDataset;
    }

    public DatasetGrid getCostGrid() {
        return this.d;
    }

    public void setCostGrid(DatasetGrid costGrid) {
        if (costGrid.getMinValue() < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("costGrid", "GridValueShouldntBeNegative", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        this.d = costGrid;
    }

    public DatasetGrid getSurfaceGrid() {
        return this.e;
    }

    public void setSurfaceGrid(DatasetGrid surfaceGrid) {
        this.e = surfaceGrid;
    }

    @Deprecated
    public Datasource getDistanceDatasource() {
        return this.f;
    }

    @Deprecated
    public void setDistanceDatasource(Datasource distanceDatasource) {
        this.f = distanceDatasource;
    }

    @Deprecated
    public Datasource getDirectionDatasource() {
        return this.g;
    }

    @Deprecated
    public void setDirectionDatasource(Datasource directionDatasource) {
        this.g = directionDatasource;
    }

    @Deprecated
    public Datasource getAllocationDatasource() {
        return this.h;
    }

    @Deprecated
    public void setAllocationDatasource(Datasource allocationDatasource) {
        this.h = allocationDatasource;
    }

    @Deprecated
    public Datasource getOutputDatasource() {
        return this.i;
    }

    @Deprecated
    public void setOutputDatasource(Datasource outputDatasource) {
        this.i = outputDatasource;
    }

    public Datasource getTargetDatasource() {
        return this.i;
    }

    public void setTargetDatasource(Datasource targetDatasource) {
        this.i = targetDatasource;
    }

    public String getDistanceGridName() {
        return this.j;
    }

    public void setDistanceGridName(String distanceGridName) {
        this.j = distanceGridName;
    }

    public String getDirectionGridName() {
        return this.k;
    }

    public void setDirectionGridName(String directionGridName) {
        this.k = directionGridName;
    }

    public String getAllocationGridName() {
        return this.l;
    }

    public void setAllocationGridName(String allocationGridName) {
        this.l = allocationGridName;
    }

    public double getMaxUpslopeDegree() {
        return this.n;
    }

    public void setMaxUpslopeDegree(double value) {
        if (value < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("MaxUpslopeDegree", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.n = value;
    }

    public double getMaxDownslopeDegree() {
        return this.o;
    }

    public void setMaxDownslopeDegree(double value) {
        if (value < 0.0) {
            String string = InternalResourceSpatialanalyst.loadString("MaxDownslopeDegree", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.o = value;
    }

    public SmoothMethod getPathLineSmoothMethod() {
        return this.p;
    }

    public void setPathLineSmoothMethod(SmoothMethod value) {
        this.p = value;
    }

    public int getPathLineSmoothDegree() {
        return this.q;
    }

    public void setPathLineSmoothDegree(int value) {
        this.q = value;
    }

    public DatasetVector getBarrierRegion() {
        return this.m;
    }

    public void setBarrierRegion(DatasetVector value) {
        this.m = value;
    }
}

