/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.ComputeType;
import com.supermap.analyst.spatialanalyst.CostPathLineResult;
import com.supermap.analyst.spatialanalyst.DistanceAnalystNative;
import com.supermap.analyst.spatialanalyst.DistanceAnalystParameter;
import com.supermap.analyst.spatialanalyst.DistanceAnalystResult;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometrySpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.PathLineResult;
import com.supermap.analyst.spatialanalyst.SmoothMethod;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class DistanceAnalyst {
    private static License a;
    private static transient Vector b;
    private static GridAnalystSetting c;

    private DistanceAnalyst() {
        c = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return c;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new GridAnalystSetting();
        }
        c.setBounds(gridAnalystSetting.getBounds());
        c.setBoundsType(gridAnalystSetting.getBoundsType());
        c.setCellSizeType(gridAnalystSetting.getCellSizeType());
        c.setCellSize(gridAnalystSetting.getCellSize());
        c.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(gridAnalystSetting.getValidRegion());
        c.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    @Deprecated
    public static DistanceAnalystResult straightDistance(Dataset sourceDataset, Datasource targetDatasource, String distanceGridName, String directionGridName, String allocationGridName, double cellSize, double maxDistance) {
        return DistanceAnalyst.straightDistance(sourceDataset, targetDatasource, distanceGridName, directionGridName, allocationGridName, cellSize, maxDistance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistanceAnalystResult straightDistance(Dataset sourceDataset, Datasource targetDatasource, String distanceGridName, String directionGridName, String allocationGridName, double cellSize, double maxDistance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (distanceGridName == null || distanceGridName.length() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("distanceGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (directionGridName != null && directionGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(directionGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (allocationGridName != null && allocationGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(allocationGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(distanceGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("distanceGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = DistanceAnalystNative.jni_New();
            if (l3 == 0L) {
                DistanceAnalystResult distanceAnalystResult = null;
                return distanceAnalystResult;
            }
            long[] lArray = DistanceAnalystNative.jni_StraightDistance(l3, l, l2, distanceGridName, directionGridName, allocationGridName, cellSize, maxDistance);
            DistanceAnalystNative.jni_Delete(l3);
            DistanceAnalystResult distanceAnalystResult = null;
            DatasetGrid datasetGrid = null;
            DatasetGrid datasetGrid2 = null;
            DatasetGrid datasetGrid3 = null;
            if (lArray != null && lArray.length == 3) {
                datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                if (directionGridName != null && directionGridName.length() > 0) {
                    datasetGrid2 = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
                }
                if (allocationGridName != null && allocationGridName.length() > 0) {
                    datasetGrid3 = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid3);
                }
                distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
            }
            DistanceAnalystResult distanceAnalystResult2 = distanceAnalystResult;
            return distanceAnalystResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DistanceAnalystResult straightDistance(DistanceAnalystParameter parameter) {
        return DistanceAnalyst.straightDistance(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistanceAnalystResult straightDistance(DistanceAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            Object object;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (parameter.getSourceDataset() == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset()) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            Datasource datasource = parameter.getTargetDatasource();
            if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                datasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            String string = parameter.getDistanceGridName();
            String string2 = parameter.getDirectionGridName();
            String string3 = parameter.getAllocationGridName();
            if (null == string) {
                String string4 = InternalResourceSpatialanalyst.loadString("distanceGridName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                string = c.getGridOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("distanceGridName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            if (string2 != null && string2.length() > 0) {
                if (null != c && null != c.getGridOutputNamePrefix()) {
                    string2 = c.getGridOutputNamePrefix() + string2;
                }
                if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
                    String string6 = InternalResourceSpatialanalyst.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string6);
                }
            }
            if (string3 != null && string3.length() > 0) {
                if (null != c && null != c.getGridOutputNamePrefix()) {
                    string3 = c.getGridOutputNamePrefix() + string3;
                }
                if (!datasource.getDatasets().isAvailableDatasetName(string3)) {
                    String string7 = InternalResourceSpatialanalyst.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string7);
                }
            }
            if (string.equals(string2) || string.equals(string3) || string2 != null && !string2.isEmpty() && string2.equals(string3)) {
                String string8 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset());
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            double d = parameter.getCellSize();
            double d2 = parameter.getMaxDistance();
            long l3 = DistanceAnalystNative.jni_New();
            if (l3 == 0L) {
                DistanceAnalystResult distanceAnalystResult = null;
                return distanceAnalystResult;
            }
            if (null != c) {
                DistanceAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
                object = c.getBounds();
                if (!object.isEmpty()) {
                    DistanceAnalystNative.jni_SetTargetBounds(l3, c.getBoundsType().value(), object.getLeft(), object.getBottom(), object.getRight(), object.getTop());
                }
                if (d <= 0.0) {
                    DistanceAnalystNative.jni_SetTargetCellSize(l3, c.getCellSizeType().value(), c.getCellSize());
                }
            }
            object = DistanceAnalystNative.jni_StraightDistance(l3, l, l2, string, string2, string3, d, d2);
            DistanceAnalystNative.jni_Delete(l3);
            DistanceAnalystResult distanceAnalystResult = null;
            DatasetGrid datasetGrid = null;
            DatasetGrid datasetGrid2 = null;
            DatasetGrid datasetGrid3 = null;
            if (object != null && ((Rectangle2D)object).length == 3 && object[0] != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance((long)object[0], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
                if (object[1] != 0L) {
                    datasetGrid2 = InternalDatasetGrid.createInstance((long)object[1], datasource);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
                }
                if (object[2] != 0L) {
                    datasetGrid3 = InternalDatasetGrid.createInstance((long)object[2], datasource);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
                }
                distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
            }
            DistanceAnalystResult distanceAnalystResult2 = distanceAnalystResult;
            return distanceAnalystResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    @Deprecated
    public static DistanceAnalystResult costDistance(Dataset sourceDataset, DatasetGrid costGrid, Datasource targetDatasource, String distanceGridName, String directionGridName, String allocationGridName, double cellSize, double maxDistance) {
        return DistanceAnalyst.costDistance(sourceDataset, costGrid, targetDatasource, distanceGridName, directionGridName, allocationGridName, cellSize, maxDistance, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistanceAnalystResult costDistance(Dataset sourceDataset, DatasetGrid costGrid, Datasource targetDatasource, String distanceGridName, String directionGridName, String allocationGridName, double cellSize, double maxDistance, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (distanceGridName == null || distanceGridName.length() == 0) {
                String string = InternalResourceSpatialanalyst.loadString("distanceGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (directionGridName != null && directionGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(directionGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (allocationGridName != null && allocationGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(allocationGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(distanceGridName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = 0L;
            if (costGrid != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)costGrid);
            }
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l4 = DistanceAnalystNative.jni_New();
            if (l4 == 0L) {
                DistanceAnalystResult distanceAnalystResult = null;
                return distanceAnalystResult;
            }
            long[] lArray = DistanceAnalystNative.jni_CostDistance(l4, l, l2, l3, distanceGridName, directionGridName, allocationGridName, cellSize, maxDistance);
            DistanceAnalystNative.jni_Delete(l4);
            DistanceAnalystResult distanceAnalystResult = null;
            DatasetGrid datasetGrid = null;
            DatasetGrid datasetGrid2 = null;
            DatasetGrid datasetGrid3 = null;
            if (lArray != null && lArray.length == 3) {
                datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
                if (directionGridName != null && directionGridName.length() > 0) {
                    datasetGrid2 = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
                }
                if (allocationGridName != null && allocationGridName.length() > 0) {
                    datasetGrid3 = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                    InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid3);
                }
                distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
            }
            DistanceAnalystResult distanceAnalystResult2 = distanceAnalystResult;
            return distanceAnalystResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DistanceAnalystResult costDistance(DistanceAnalystParameter parameter) {
        return DistanceAnalyst.costDistance(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistanceAnalystResult costDistance(DistanceAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            Object object;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (parameter.getSourceDataset() == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset()) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            Datasource datasource = parameter.getTargetDatasource();
            if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                datasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            String string = parameter.getDistanceGridName();
            String string2 = parameter.getDirectionGridName();
            String string3 = parameter.getAllocationGridName();
            if (null == string) {
                String string4 = InternalResourceSpatialanalyst.loadString("distanceGridName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                string = c.getGridOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("distanceGridName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            if (string2 != null && string2.length() > 0) {
                if (null != c && null != c.getGridOutputNamePrefix()) {
                    string2 = c.getGridOutputNamePrefix() + string2;
                }
                if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
                    String string6 = InternalResourceSpatialanalyst.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string6);
                }
            }
            if (string3 != null && string3.length() > 0) {
                if (null != c && null != c.getGridOutputNamePrefix()) {
                    string3 = c.getGridOutputNamePrefix() + string3;
                }
                if (!datasource.getDatasets().isAvailableDatasetName(string3)) {
                    String string7 = InternalResourceSpatialanalyst.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string7);
                }
            }
            if (string.equals(string2) || string.equals(string3) || string2 != null && !string2.isEmpty() && string2.equals(string3)) {
                String string8 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset());
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l3 = 0L;
            if (parameter.getCostGrid() != null) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getCostGrid());
            }
            double d = parameter.getCellSize();
            double d2 = parameter.getMaxDistance();
            long l4 = DistanceAnalystNative.jni_New();
            if (l4 == 0L) {
                DistanceAnalystResult distanceAnalystResult = null;
                return distanceAnalystResult;
            }
            if (null != c) {
                DistanceAnalystNative.jni_SetShowProgress(l4, c.isShowProgress());
                object = c.getBounds();
                if (!object.isEmpty()) {
                    DistanceAnalystNative.jni_SetTargetBounds(l4, c.getBoundsType().value(), object.getLeft(), object.getBottom(), object.getRight(), object.getTop());
                }
                if (d <= 0.0) {
                    DistanceAnalystNative.jni_SetTargetCellSize(l4, c.getCellSizeType().value(), c.getCellSize());
                }
            }
            object = DistanceAnalystNative.jni_CostDistance(l4, l, l3, l2, string, string2, string3, d, d2);
            DistanceAnalystNative.jni_Delete(l4);
            DistanceAnalystResult distanceAnalystResult = null;
            DatasetGrid datasetGrid = null;
            DatasetGrid datasetGrid2 = null;
            DatasetGrid datasetGrid3 = null;
            if (object != null && ((Rectangle2D)object).length == 3 && object[0] != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance((long)object[0], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
                if (object[1] != 0L) {
                    datasetGrid2 = InternalDatasetGrid.createInstance((long)object[1], datasource);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
                }
                if (object[2] != 0L) {
                    datasetGrid3 = InternalDatasetGrid.createInstance((long)object[2], datasource);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
                }
                distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
            }
            DistanceAnalystResult distanceAnalystResult2 = distanceAnalystResult;
            return distanceAnalystResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DistanceAnalystResult surfaceDistance(DistanceAnalystParameter parameter) {
        return DistanceAnalyst.surfaceDistance(parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistanceAnalystResult surfaceDistance(DistanceAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            Object object;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (parameter.getSourceDataset() == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset()) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            Datasource datasource = parameter.getTargetDatasource();
            if (datasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                datasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            String string = parameter.getDistanceGridName();
            String string2 = parameter.getDirectionGridName();
            String string3 = parameter.getAllocationGridName();
            if (null == string) {
                String string4 = InternalResourceSpatialanalyst.loadString("distanceGridName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string4);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                string = c.getGridOutputNamePrefix() + string;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string5 = InternalResourceSpatialanalyst.loadString("distanceGridName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string5);
            }
            if (string2 != null && string2.length() > 0) {
                if (null != c && null != c.getGridOutputNamePrefix()) {
                    string2 = c.getGridOutputNamePrefix() + string2;
                }
                if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
                    String string6 = InternalResourceSpatialanalyst.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string6);
                }
            }
            if (string3 != null && string3.length() > 0) {
                if (null != c && null != c.getGridOutputNamePrefix()) {
                    string3 = c.getGridOutputNamePrefix() + string3;
                }
                if (!datasource.getDatasets().isAvailableDatasetName(string3)) {
                    String string7 = InternalResourceSpatialanalyst.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string7);
                }
            }
            if (string.equals(string2) || string.equals(string3) || string2 != null && !string2.isEmpty() && string2.equals(string3)) {
                String string8 = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string8);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSourceDataset());
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasource);
            long l3 = 0L;
            if (parameter.getSurfaceGrid() != null) {
                l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getSurfaceGrid());
            }
            double d = parameter.getCellSize();
            double d2 = parameter.getMaxDistance();
            double d3 = parameter.getMaxUpslopeDegree();
            double d4 = parameter.getMaxDownslopeDegree();
            long l4 = DistanceAnalystNative.jni_New();
            if (l4 == 0L) {
                DistanceAnalystResult distanceAnalystResult = null;
                return distanceAnalystResult;
            }
            if (null != c) {
                DistanceAnalystNative.jni_SetShowProgress(l4, c.isShowProgress());
                object = c.getBounds();
                if (!object.isEmpty()) {
                    DistanceAnalystNative.jni_SetTargetBounds(l4, c.getBoundsType().value(), object.getLeft(), object.getBottom(), object.getRight(), object.getTop());
                }
                if (d <= 0.0) {
                    DistanceAnalystNative.jni_SetTargetCellSize(l4, c.getCellSizeType().value(), c.getCellSize());
                }
            }
            object = DistanceAnalystNative.jni_SurfaceDistance(l4, l, l3, l2, string, string2, string3, d, d2, d3, d4);
            DistanceAnalystNative.jni_Delete(l4);
            DistanceAnalystResult distanceAnalystResult = null;
            DatasetGrid datasetGrid = null;
            DatasetGrid datasetGrid2 = null;
            DatasetGrid datasetGrid3 = null;
            if (object != null && ((Rectangle2D)object).length == 3 && object[0] != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance((long)object[0], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
                if (object[1] != 0L) {
                    datasetGrid2 = InternalDatasetGrid.createInstance((long)object[1], datasource);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
                }
                if (object[2] != 0L) {
                    datasetGrid3 = InternalDatasetGrid.createInstance((long)object[2], datasource);
                    InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
                }
                distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
            }
            DistanceAnalystResult distanceAnalystResult2 = distanceAnalystResult;
            return distanceAnalystResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid costPath(Dataset sourceDataset, DatasetGrid distanceDataset, DatasetGrid directionDataset, ComputeType computeType, Datasource targetDatasource, String targetDatasetName) {
        return DistanceAnalyst.costPath(sourceDataset, distanceDataset, directionDataset, computeType, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid costPath(Dataset sourceDataset, DatasetGrid distanceDataset, DatasetGrid directionDataset, ComputeType computeType, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (distanceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)distanceDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("distanceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (directionDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)directionDataset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("directionDataset", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : sourceDataset.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getGridOutputNamePrefix()) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)distanceDataset);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)directionDataset);
            long l4 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(computeType);
            long l5 = DistanceAnalystNative.jni_New();
            if (l5 == 0L) {
                DatasetGrid datasetGrid = null;
                return datasetGrid;
            }
            if (null != c) {
                DistanceAnalystNative.jni_SetShowProgress(l5, c.isShowProgress());
            }
            long l6 = DistanceAnalystNative.jni_CostPath(l5, l, l2, l3, n, l4, targetDatasetName);
            DistanceAnalystNative.jni_Delete(l5);
            DatasetGrid datasetGrid = null;
            if (l6 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    @Deprecated
    public static CostPathLineResult costPathLine(Point2D sourcePoint, Point2D targetPoint, DatasetGrid costGrid, SmoothMethod smoothMethod, int smoothDegree, Datasource targetDatasource, String targetDatasetName) {
        return DistanceAnalyst.costPathLine(sourcePoint, targetPoint, costGrid, smoothMethod, smoothDegree, targetDatasource, targetDatasetName, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CostPathLineResult costPathLine(Point2D sourcePoint, Point2D targetPoint, DatasetGrid costGrid, SmoothMethod smoothMethod, int smoothDegree, Datasource targetDatasource, String targetDatasetName, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (sourcePoint == null || targetPoint == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint or targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (costGrid == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)costGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("costGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                targetDatasource = c != null && c.getOutputDatasource() != null ? c.getOutputDatasource() : costGrid.getDatasource();
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == targetDatasetName) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null != c && null != c.getVectorOutputNamePrefix()) {
                targetDatasetName = c.getVectorOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)costGrid);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            int n = InternalEnum.getUGCValue(smoothMethod);
            double[] dArray = new double[1];
            long l3 = DistanceAnalystNative.jni_New();
            if (l3 == 0L) {
                CostPathLineResult costPathLineResult = null;
                return costPathLineResult;
            }
            if (null != c) {
                DistanceAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
            }
            long l4 = DistanceAnalystNative.jni_CostPathLineDeprecated(l3, sourcePoint.getX(), sourcePoint.getY(), targetPoint.getX(), targetPoint.getY(), l, n, smoothDegree, l2, targetDatasetName, dArray);
            DistanceAnalystNative.jni_Delete(l3);
            DatasetVector datasetVector = null;
            CostPathLineResult costPathLineResult = null;
            if (l4 != 0L) {
                datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
                costPathLineResult = new CostPathLineResult(datasetVector, dArray[0]);
            }
            CostPathLineResult costPathLineResult2 = costPathLineResult;
            return costPathLineResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static PathLineResult costPathLine(Point2D sourcePoint, Point2D targetPoint, DistanceAnalystParameter parameter) {
        return DistanceAnalyst.costPathLine(sourcePoint, targetPoint, parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PathLineResult costPathLine(Point2D sourcePoint, Point2D targetPoint, DistanceAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (sourcePoint == null || targetPoint == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint or targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            DatasetGrid datasetGrid = parameter.getCostGrid();
            if (datasetGrid == null) {
                String string = InternalResourceSpatialanalyst.loadString("CostGrid and SurfaceGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("CostGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGrid);
            long l2 = 0L;
            if (parameter.getBarrierRegion() != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getBarrierRegion());
            }
            int n = InternalEnum.getUGCValue(parameter.getPathLineSmoothMethod());
            double[] dArray = new double[1];
            long l3 = DistanceAnalystNative.jni_New();
            if (l3 == 0L) {
                PathLineResult pathLineResult = null;
                return pathLineResult;
            }
            if (null != c) {
                DistanceAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
            }
            long l4 = DistanceAnalystNative.jni_CostPathLine(l3, sourcePoint.getX(), sourcePoint.getY(), targetPoint.getX(), targetPoint.getY(), l, n, parameter.getPathLineSmoothDegree(), dArray, l2);
            DistanceAnalystNative.jni_Delete(l3);
            GeoLine geoLine = null;
            PathLineResult pathLineResult = null;
            if (l4 != 0L) {
                geoLine = (GeoLine)InternalGeometrySpatialanalyst.createInstance(l4);
                pathLineResult = new PathLineResult(geoLine, dArray[0]);
            }
            PathLineResult pathLineResult2 = pathLineResult;
            return pathLineResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static PathLineResult surfacePathLine(Point2D sourcePoint, Point2D targetPoint, DistanceAnalystParameter parameter) {
        return DistanceAnalyst.surfacePathLine(sourcePoint, targetPoint, parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PathLineResult surfacePathLine(Point2D sourcePoint, Point2D targetPoint, DistanceAnalystParameter parameter, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            DistanceAnalyst.a();
            if (sourcePoint == null || targetPoint == null) {
                String string = InternalResourceSpatialanalyst.loadString("sourcePoint or targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            DatasetGrid datasetGrid = parameter.getSurfaceGrid();
            if (datasetGrid == null) {
                String string = InternalResourceSpatialanalyst.loadString("SurfaceGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGrid) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("CostGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGrid);
            long l2 = 0L;
            if (parameter.getBarrierRegion() != null) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getBarrierRegion());
            }
            int n = InternalEnum.getUGCValue(parameter.getPathLineSmoothMethod());
            double[] dArray = new double[1];
            long l3 = DistanceAnalystNative.jni_New();
            if (l3 == 0L) {
                PathLineResult pathLineResult = null;
                return pathLineResult;
            }
            if (null != c) {
                DistanceAnalystNative.jni_SetShowProgress(l3, c.isShowProgress());
            }
            long l4 = DistanceAnalystNative.jni_SurfacePathLine(l3, sourcePoint.getX(), sourcePoint.getY(), targetPoint.getX(), targetPoint.getY(), l, parameter.getMaxUpslopeDegree(), parameter.getMaxDownslopeDegree(), n, parameter.getPathLineSmoothDegree(), dArray, l2);
            DistanceAnalystNative.jni_Delete(l3);
            GeoLine geoLine = null;
            PathLineResult pathLineResult = null;
            if (l4 != 0L) {
                geoLine = (GeoLine)InternalGeometrySpatialanalyst.createInstance(l4);
                pathLineResult = new PathLineResult(geoLine, dArray[0]);
            }
            PathLineResult pathLineResult2 = pathLineResult;
            return pathLineResult2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static PathLineResult pathLine(Point2D targetPoint, DatasetGrid distanceGrid, DatasetGrid directionGrid, SmoothMethod smoothMethod, int smoothDegree) {
        DistanceAnalyst.a();
        if (targetPoint == null) {
            String string = InternalResourceSpatialanalyst.loadString("targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (distanceGrid == null) {
            String string = InternalResourceSpatialanalyst.loadString("distanceGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandleSpatialanalyst.getHandle((InternalHandle)distanceGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("distanceGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (directionGrid == null) {
            String string = InternalResourceSpatialanalyst.loadString("directionGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandleSpatialanalyst.getHandle((InternalHandle)directionGrid) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)distanceGrid);
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)directionGrid);
        int n = InternalEnum.getUGCValue(smoothMethod);
        double[] dArray = new double[1];
        long l3 = DistanceAnalystNative.jni_New();
        if (l3 == 0L) {
            return null;
        }
        long l4 = DistanceAnalystNative.jni_PathLine(l3, targetPoint.getX(), targetPoint.getY(), l, l2, n, smoothDegree, dArray);
        DistanceAnalystNative.jni_Delete(l3);
        GeoLine geoLine = null;
        PathLineResult pathLineResult = null;
        if (l4 != 0L) {
            geoLine = (GeoLine)InternalGeometrySpatialanalyst.createInstance(l4);
            pathLineResult = new PathLineResult(geoLine, dArray[0]);
        }
        return pathLineResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "DistanceAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

