/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.ClassificationNative;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandle;

public class Classification {
    public double[] computeNaturalBreaks(DatasetGrid sourceDataset, int numberZones) {
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (numberZones < 1) {
            String string = InternalResourceSpatialanalyst.loadString("numberZones", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        double[] dArray = ClassificationNative.jni_NaturalBreaksRaster(l, numberZones);
        return dArray;
    }

    public double[] computeNaturalBreaks(DatasetVector sourceDataset, String valueFieldName, int numberZones) {
        if (sourceDataset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset) == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (numberZones < 1) {
            String string = InternalResourceSpatialanalyst.loadString("numberZones", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (valueFieldName == null) {
            String string = InternalResourceSpatialanalyst.loadString("valueFieldName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        FieldInfos fieldInfos = sourceDataset.getFieldInfos();
        if (fieldInfos.indexOf(valueFieldName) == -1) {
            String string = InternalResourceSpatialanalyst.loadString("valueFieldName", "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)sourceDataset);
        double[] dArray = ClassificationNative.jni_NaturalBreaksVector(l, valueFieldName, numberZones);
        return dArray;
    }

    public double[] computeNaturalBreaks(double[] values, int numberZones) {
        int n = values.length;
        if (n < 1) {
            String string = InternalResourceSpatialanalyst.loadString("values.length", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < numberZones) {
            String string = InternalResourceSpatialanalyst.loadString("numberZones > values.length", "Global_IndexOutOfBounds", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (numberZones < 1) {
            String string = InternalResourceSpatialanalyst.loadString("numberZones", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = ClassificationNative.jni_NaturalBreaks(values, numberZones);
        return dArray;
    }
}

