/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.opengis.referencing.AuthorityFactory;

public abstract class DirectAuthorityFactory
extends AbstractAuthorityFactory {
    protected final ReferencingFactoryContainer factories;
    private boolean hintsInitialized;

    protected DirectAuthorityFactory(ReferencingFactoryContainer factories, int priority) {
        super(priority);
        this.factories = factories;
        DirectAuthorityFactory.ensureNonNull("factories", (Object)factories);
    }

    protected DirectAuthorityFactory(Hints hints, int priority) {
        super(priority);
        this.factories = ReferencingFactoryContainer.instance(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (!this.hintsInitialized) {
                this.hintsInitialized = true;
                this.hints.putAll(this.factories.getImplementationHints());
            }
        }
        return super.getImplementationHints();
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        if (this.factories != null) {
            LinkedHashSet<Object> dependencies = new LinkedHashSet<Object>(8);
            dependencies.add(this.factories.getCRSFactory());
            dependencies.add(this.factories.getCSFactory());
            dependencies.add(this.factories.getDatumFactory());
            return dependencies;
        }
        return super.dependencies();
    }
}

