/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.ParticleSystemNative;
import com.supermap.data.Point3D;
import java.awt.Color;

public class ParticleSystem
extends InternalHandleDisposable {
    private ParticleSystem() {
        long l = ParticleSystemNative.jni_New();
        this.setHandle(l, true);
    }

    private ParticleSystem(ParticleSystem particleSystem) {
        this(particleSystem, true);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected ParticleSystem(ParticleSystem particleSystem, boolean dispose) {
        if (particleSystem == null) {
            String string = InternalResource.loadString("Material", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (particleSystem.getHandle() == 0L) {
            String string = InternalResource.loadString("Material", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ParticleSystemNative.jni_Clone(particleSystem.getHandle());
        this.setHandle(l, dispose);
        InternalHandleDisposable.makeSureNativeObjectLive(particleSystem);
    }

    ParticleSystem(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ParticleSystemNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public Point3D getLocalCenterPos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLocalCenterPos", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[3];
        ParticleSystemNative.jni_GetLocalCenterPos(this.getHandle(), dArray);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setLocalCenterPos(Point3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLocalCenterPos", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetLocalCenterPos(this.getHandle(), value.getX(), value.getY(), value.getZ());
    }

    public float getParticleWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleWidth(this.getHandle());
    }

    public void setParticleWidth(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleWidth", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleWidth(this.getHandle(), value);
    }

    public float getParticleHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleHeight", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleHeight(this.getHandle());
    }

    public void setParticleHeight(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleHeight", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleHeight(this.getHandle(), value);
    }

    public int getParticleLifeTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleLifeTime(this.getHandle());
    }

    public void setParticleLifeTime(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleLifeTime(this.getHandle(), value);
    }

    public int getParticleCountPerSecond() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetParticleCountPerSecond(this.getHandle());
    }

    public void setParticleCountPerSecond(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParticleLifeTime", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ParticleSystemNative.jni_SetParticleCountPerSecond(this.getHandle(), value);
    }

    public Color getColorRangeStart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorRangeStart", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(ParticleSystemNative.jni_GetColorRangeStart(this.getHandle()), true);
        return color;
    }

    public void setColorRangeStart(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorRangeStart", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setColorRangeStart", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        ParticleSystemNative.jni_SetColorRangeStart(this.getHandle(), value.getRGB());
    }

    public Color getColorRangeEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorRangeEnd", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(ParticleSystemNative.jni_GetColorRangeEnd(this.getHandle()), true);
        return color;
    }

    public void setColorRangeEnd(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorRangeEnd", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setColorRangeEnd", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        ParticleSystemNative.jni_SetColorRangeEnd(this.getHandle(), value.getRGB());
    }

    public String getTexturePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTexturePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetTexturePath(this.getHandle());
    }

    public void setTexturePath(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTexturePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setTexturePath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        ParticleSystemNative.jni_SetTexturePath(this.getHandle(), value);
    }

    public String getColorRangeImagePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorRangeImagePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ParticleSystemNative.jni_GetColorRangeImagePath(this.getHandle());
    }

    public void setColorRangeImagePath(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorRangeImagePath", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setColorRangeImagePath", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        ParticleSystemNative.jni_SetColorRangeImagePath(this.getHandle(), value);
    }
}

