/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.MapAddedEvent;
import com.supermap.data.MapAddedListener;
import com.supermap.data.MapClearedEvent;
import com.supermap.data.MapClearedListener;
import com.supermap.data.MapClearingEvent;
import com.supermap.data.MapClearingListener;
import com.supermap.data.MapRemovedEvent;
import com.supermap.data.MapRemovedListener;
import com.supermap.data.MapRemovingEvent;
import com.supermap.data.MapRemovingListener;
import com.supermap.data.MapRenamedEvent;
import com.supermap.data.MapRenamedListener;
import com.supermap.data.MapRenamingEvent;
import com.supermap.data.MapRenamingListener;
import com.supermap.data.MapsNative;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceVersion;
import java.util.concurrent.CopyOnWriteArrayList;

public class Maps {
    private Workspace h;
    transient CopyOnWriteArrayList<MapRenamingListener> a;
    transient CopyOnWriteArrayList<MapRenamedListener> b;
    transient CopyOnWriteArrayList<MapRemovingListener> c;
    transient CopyOnWriteArrayList<MapRemovedListener> d;
    transient CopyOnWriteArrayList<MapAddedListener> e;
    transient CopyOnWriteArrayList<MapClearingListener> f;
    transient CopyOnWriteArrayList<MapClearedListener> g;

    Maps(Workspace workspace) {
        this.h = workspace;
    }

    public int getCount() {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MapsNative.jni_GetCount(this.h.getHandle());
    }

    public String get(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return MapsNative.jni_GetItem(this.h.getHandle(), index);
    }

    public int add(String name, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = MapsNative.jni_Add(this.h.getHandle(), name, xml);
        if (n > -1) {
            MapAddedEvent mapAddedEvent = new MapAddedEvent(this, name);
            this.fireAdded(mapAddedEvent);
        }
        return n;
    }

    public int add(String name, String xml, WorkspaceVersion version) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        int n2 = version.value();
        n = MapsNative.jni_Add2(this.h.getHandle(), name, xml, n2);
        if (n > -1) {
            MapAddedEvent mapAddedEvent = new MapAddedEvent(this, name);
            this.fireAdded(mapAddedEvent);
        }
        return n;
    }

    public boolean insert(int index, String name, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MapsNative.jni_Insert(this.h.getHandle(), index, name, xml);
    }

    public boolean insert(int index, String name, String xml, WorkspaceVersion version) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = version.value();
        return MapsNative.jni_Insert2(this.h.getHandle(), index, name, xml, n);
    }

    public boolean setMapXML(int index, String xml) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        return MapsNative.jni_SetMapXML(this.h.getHandle(), index, xml);
    }

    public boolean setMapXML(int index, String xml, WorkspaceVersion version) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        int n = version.value();
        return MapsNative.jni_SetMapXML2(this.h.getHandle(), index, xml, n);
    }

    public boolean setMapXML(String name, String xml) {
        int n;
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setMapXML(n, xml);
    }

    public boolean setMapXML(String name, String xml, WorkspaceVersion version) {
        int n;
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setMapXML(n, xml, version);
    }

    public String getMapXML(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return MapsNative.jni_GetMapXML(this.h.getHandle(), index);
    }

    public String getMapXML(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return MapsNative.jni_GetMapXML(this.h.getHandle(), n);
    }

    public boolean remove(int index) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(index);
        MapRemovingEvent mapRemovingEvent = new MapRemovingEvent(this, string);
        this.fireRemoving(mapRemovingEvent);
        if (mapRemovingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = MapsNative.jni_Remove(this.h.getHandle(), index);
        if (bl) {
            MapRemovedEvent mapRemovedEvent = new MapRemovedEvent(this, string);
            this.fireRemoved(mapRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.indexOf(name);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MapClearingEvent mapClearingEvent = new MapClearingEvent(this);
        this.fireClearing(mapClearingEvent);
        if (mapClearingEvent.isCancel()) {
            return;
        }
        int n = this.getCount();
        MapsNative.jni_Clear(this.h.getHandle());
        MapClearedEvent mapClearedEvent = new MapClearedEvent(this, n);
        this.fireCleared(mapClearedEvent);
    }

    public int indexOf(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = MapsNative.jni_IndexOf(this.h.getHandle(), name);
        }
        return n;
    }

    public String getAvailableMapName(String name) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        return MapsNative.jni_GetUnoccupiedMapName(this.h.getHandle(), name);
    }

    public boolean rename(String oldName, String newName) {
        if (this.h == null || this.h.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName == null || newName.trim().length() == 0) {
            String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(oldName) == -1) {
            String string = InternalResource.loadString("oldName", "Maps_NameIsNotInMaps", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName.equalsIgnoreCase(oldName)) {
            return false;
        }
        if (this.indexOf(newName) >= 0) {
            String string = InternalResource.loadString("newName", "Maps_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MapRenamingEvent mapRenamingEvent = new MapRenamingEvent(this, oldName, newName);
        this.fireRenaming(mapRenamingEvent);
        if (mapRenamingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = MapsNative.jni_Rename(this.h.getHandle(), oldName, newName);
        if (bl) {
            MapRenamedEvent mapRenamedEvent = new MapRenamedEvent(this, oldName, newName);
            this.fireRenamed(mapRenamedEvent);
        }
        return bl;
    }

    protected void clearHandle() {
        this.h = null;
    }

    public synchronized void addRenamingListener(MapRenamingListener l) {
        if (this.a == null) {
            this.a = new CopyOnWriteArrayList();
        }
        if (!this.a.contains(l)) {
            this.a.add(l);
        }
    }

    public void removeRenamingListener(MapRenamingListener l) {
        if (this.a != null && this.a.contains(l)) {
            this.a.remove(l);
        }
    }

    protected void fireRenaming(MapRenamingEvent event) {
        if (this.a != null) {
            CopyOnWriteArrayList<MapRenamingListener> copyOnWriteArrayList = this.a;
            for (MapRenamingListener mapRenamingListener : copyOnWriteArrayList) {
                mapRenamingListener.mapRenaming(event);
            }
        }
    }

    public synchronized void addRenamedListener(MapRenamedListener l) {
        if (this.b == null) {
            this.b = new CopyOnWriteArrayList();
        }
        if (!this.b.contains(l)) {
            this.b.add(l);
        }
    }

    public void removeRenamedListener(MapRenamedListener l) {
        if (this.b != null && this.b.contains(l)) {
            this.b.remove(l);
        }
    }

    protected void fireRenamed(MapRenamedEvent event) {
        if (this.b != null) {
            CopyOnWriteArrayList<MapRenamedListener> copyOnWriteArrayList = this.b;
            for (MapRenamedListener mapRenamedListener : copyOnWriteArrayList) {
                mapRenamedListener.mapRenamed(event);
            }
        }
    }

    public synchronized void addRemovingListener(MapRemovingListener l) {
        if (this.c == null) {
            this.c = new CopyOnWriteArrayList();
        }
        if (!this.c.contains(l)) {
            this.c.add(l);
        }
    }

    public void removeRemovingListener(MapRemovingListener l) {
        if (this.c != null && this.c.contains(l)) {
            this.c.remove(l);
        }
    }

    protected void fireRemoving(MapRemovingEvent event) {
        if (this.c != null) {
            CopyOnWriteArrayList<MapRemovingListener> copyOnWriteArrayList = this.c;
            for (MapRemovingListener mapRemovingListener : copyOnWriteArrayList) {
                mapRemovingListener.mapRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(MapRemovedListener l) {
        if (this.d == null) {
            this.d = new CopyOnWriteArrayList();
        }
        if (!this.d.contains(l)) {
            this.d.add(l);
        }
    }

    public void removeRemovedListener(MapRemovedListener l) {
        if (this.d != null && this.d.contains(l)) {
            this.d.remove(l);
        }
    }

    protected void fireRemoved(MapRemovedEvent event) {
        if (this.d != null) {
            CopyOnWriteArrayList<MapRemovedListener> copyOnWriteArrayList = this.d;
            for (MapRemovedListener mapRemovedListener : copyOnWriteArrayList) {
                mapRemovedListener.mapRemoved(event);
            }
        }
    }

    public synchronized void addAddedListener(MapAddedListener l) {
        if (this.e == null) {
            this.e = new CopyOnWriteArrayList();
        }
        if (!this.e.contains(l)) {
            this.e.add(l);
        }
    }

    public void removeAddedListener(MapAddedListener l) {
        if (this.e != null && this.e.contains(l)) {
            this.e.remove(l);
        }
    }

    protected void fireAdded(MapAddedEvent event) {
        if (this.e != null) {
            CopyOnWriteArrayList<MapAddedListener> copyOnWriteArrayList = this.e;
            for (MapAddedListener mapAddedListener : copyOnWriteArrayList) {
                mapAddedListener.mapAdded(event);
            }
        }
    }

    public synchronized void addClearingListener(MapClearingListener l) {
        if (this.f == null) {
            this.f = new CopyOnWriteArrayList();
        }
        if (!this.f.contains(l)) {
            this.f.add(l);
        }
    }

    public void removeClearingListener(MapClearingListener l) {
        if (this.f != null && this.f.contains(l)) {
            this.f.remove(l);
        }
    }

    protected void fireClearing(MapClearingEvent event) {
        if (this.f != null) {
            CopyOnWriteArrayList<MapClearingListener> copyOnWriteArrayList = this.f;
            for (MapClearingListener mapClearingListener : copyOnWriteArrayList) {
                mapClearingListener.mapClearing(event);
            }
        }
    }

    public synchronized void addClearedListener(MapClearedListener l) {
        if (this.g == null) {
            this.g = new CopyOnWriteArrayList();
        }
        if (!this.g.contains(l)) {
            this.g.add(l);
        }
    }

    public void removeClearedListener(MapClearedListener l) {
        if (this.g != null && this.g.contains(l)) {
            this.g.remove(l);
        }
    }

    protected void fireCleared(MapClearedEvent event) {
        if (this.g != null) {
            CopyOnWriteArrayList<MapClearedListener> copyOnWriteArrayList = this.g;
            for (MapClearedListener mapClearedListener : copyOnWriteArrayList) {
                mapClearedListener.mapCleared(event);
            }
        }
    }
}

