/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.JoinItem;
import com.supermap.data.JoinItemsNative;
import java.util.ArrayList;

public class JoinItems
extends InternalHandleDisposable {
    private ArrayList a = null;

    public JoinItems() {
        this.a = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
    }

    public JoinItems(JoinItem[] joinItems) {
        if (joinItems == null) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.a = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
        for (int i = 0; i < joinItems.length; ++i) {
            this.add(joinItems[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItems);
    }

    public JoinItems(JoinItems joinItems) {
        if (joinItems == null) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (joinItems.getHandle() == 0L) {
            String string = InternalResource.loadString("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = JoinItemsNative.jni_Clone(joinItems.getHandle());
        this.a = new ArrayList();
        this.setHandle(l, true);
        int n = joinItems.getCount();
        for (int i = 0; i < n; ++i) {
            this.add(joinItems.get(i));
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItems);
    }

    JoinItems(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList();
        int n = JoinItemsNative.jni_GetCount(this.getHandle());
        long[] lArray = new long[n];
        JoinItemsNative.jni_GetHandles(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            this.a.add(new JoinItem(lArray[i]));
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    public JoinItem get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (JoinItem)this.a.get(index);
    }

    public void set(int index, JoinItem value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        JoinItemsNative.jni_Set(this.get(index).getHandle(), value.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    public JoinItems clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new JoinItems(this);
    }

    public int add(JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("joinItem", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = JoinItemsNative.jni_Add(this.getHandle(), joinItem.getHandle());
        if (l != 0L) {
            JoinItem joinItem2 = new JoinItem(l);
            this.a.add(joinItem2);
            InternalHandleDisposable.makeSureNativeObjectLive(joinItem);
            return this.getCount() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItem);
        return -1;
    }

    public int addRange(JoinItem[] joinItems) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = 0;
        int n3 = joinItems.length;
        for (n = 0; n < n3; ++n) {
            JoinItem joinItem = joinItems[n];
            if (joinItem == null) {
                String string = InternalResource.loadString("joinItems[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("joinItems[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < n3; ++n) {
            this.add(joinItems[n]);
            ++n2;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItems);
        return n2;
    }

    public boolean insert(int index, JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, JoinItem joinItem)", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index == this.getCount()) {
            return this.add(joinItem) != -1;
        }
        long l = JoinItemsNative.jni_Insert(this.getHandle(), index, joinItem.getHandle());
        if (l == 0L) {
            return false;
        }
        JoinItem joinItem2 = new JoinItem(l);
        this.a.add(index, joinItem2);
        InternalHandleDisposable.makeSureNativeObjectLive(joinItem);
        return true;
    }

    public int insertRange(int index, JoinItem[] joinItems) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n2 = joinItems.length;
        for (n = 0; n < n2; ++n) {
            JoinItem joinItem = joinItems[n];
            if (joinItem == null) {
                String string = InternalResource.loadString("joinItems[" + n + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = InternalResource.loadString("joinItems[" + n + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            bl = this.insert(index + n, joinItems[i]);
            if (!bl) continue;
            ++n;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(joinItems);
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        JoinItemsNative.jni_Remove(this.getHandle(), index);
        JoinItem joinItem = this.get(index);
        joinItem.clearHandle();
        this.a.remove(index);
        return true;
    }

    public int removeRange(int index, int count) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (count < 0 || count > this.getCount() - index) {
            String string = InternalResource.loadString("count", "JoinItems_RemoveRangeCountInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        boolean bl = false;
        for (int i = index + count - 1; i >= index; --i) {
            try {
                bl = this.remove(i);
                if (!bl) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        for (int i = n - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public JoinItem[] toArray() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.a.size();
        JoinItem[] joinItemArray = new JoinItem[n];
        for (int i = 0; i < n; ++i) {
            joinItemArray[i] = new JoinItem(this.get(i));
        }
        return joinItemArray;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            JoinItemsNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                JoinItem joinItem = this.get(i);
                joinItem.clearHandle();
            }
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }
}

