/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Geometry;
import com.supermap.data.GeometryEPSNative;
import com.supermap.data.InternalResource;
import com.supermap.data.PointParametric;
import com.supermap.data.PointParametricType;

public abstract class GeometryParametric
extends Geometry {
    protected GeometryParametric() {
    }

    @Override
    public void dispose() {
    }

    public int add(PointParametric point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeometryEPSNative.jni_Add(this.getHandle(), point.getX(), point.getY(), point.getZ(), point.getType().value(), point.getName());
        return n;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeometryEPSNative.jni_Remove(this.getHandle(), index);
        return bl;
    }

    public PointParametric get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[3];
        int[] nArray = new int[1];
        String[] stringArray = new String[1];
        GeometryEPSNative.jni_Get(this.getHandle(), index, dArray, nArray, stringArray);
        return new PointParametric(dArray[0], dArray[1], dArray[2], PointParametricType.get(nArray[0]), stringArray[0]);
    }

    public boolean insert(int index, PointParametric point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insertPart(int index, PointParametric points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.getCount();
        if (n == index) {
            int n2 = this.add(point);
            bl = n2 == index;
            return bl;
        }
        if (index < 0 || index > n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        bl = GeometryEPSNative.jni_Insert(this.getHandle(), index, point.getX(), point.getY(), point.getZ(), point.getType().value(), point.getName());
        return bl;
    }

    public boolean set(int index, PointParametric point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, PointParametric point)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeometryEPSNative.jni_Set(this.getHandle(), index, point.getX(), point.getY(), point.getZ(), point.getType().value(), point.getName());
        return bl;
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeometryEPSNative.jni_GetCount(this.getHandle());
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeometryEPSNative.jni_Clear(this.getHandle());
    }
}

