/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPyramidNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;
import com.supermap.data.Size2D;

public class GeoPyramid
extends Geometry3D {
    public GeoPyramid() {
        long l = GeoPyramidNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoPyramid(GeoPyramid geoPyramid) {
        if (geoPyramid == null) {
            String string = InternalResource.loadString("geoPyramid", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoPyramid);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPyramid", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPyramidNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPyramid);
    }

    public GeoPyramid(Point3D position, Size2D bottomSize, double height) {
        double d2 = position.getX();
        double d3 = position.getY();
        double d4 = position.getZ();
        double d5 = bottomSize.getHeight();
        double d6 = bottomSize.getWidth();
        if (d6 <= 0.0) {
            String string = InternalResource.loadString("bottomSize.getWidth()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d5 <= 0.0) {
            String string = InternalResource.loadString("bottomSize.getHeight()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (height <= 0.0) {
            String string = InternalResource.loadString("height", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPyramidNative.jni_New2(d2, d3, d4, d6, d5, height);
        this.setHandle(l, true);
    }

    GeoPyramid(long handle) {
        this.setHandle(handle, false);
    }

    public Size2D getBottomSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBottomSize()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoPyramidNative.jni_GetBottomSize(this.getHandle(), dArray);
        Size2D size2D = new Size2D();
        size2D.setWidth(dArray[0]);
        size2D.setHeight(dArray[1]);
        return size2D;
    }

    public void setBottomSize(Size2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBottomSize(Size2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = value.getWidth();
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("value.getWidth()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d3 = value.getHeight();
        if (d3 <= 0.0) {
            String string = InternalResource.loadString("value.getHeight()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPyramidNative.jni_SetBottomSize(this.getHandle(), d2, d3);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPyramidNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPyramid_HeightShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPyramidNative.jni_SetHeight(this.getHandle(), value);
    }

    @Override
    public GeoPyramid clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPyramid(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPyramidNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

