/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeoPointEPSNative;
import com.supermap.data.GeometryParametric;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.PointParametric;

public class GeoPointParametric
extends GeometryParametric {
    public GeoPointParametric() {
        long l = GeoPointEPSNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoPointParametric(PointParametric point) {
        this();
        this.add(point);
    }

    public GeoPointParametric(GeoPointParametric geoPoint) {
        if (geoPoint.getHandle() == 0L) {
            String string = InternalResource.loadString("geoPoint", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoPointEPSNative.jni_Clone(geoPoint.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPoint);
    }

    GeoPointParametric(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPointEPSNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    @Override
    public GeoPointParametric clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPointParametric(this);
    }

    public GeoPoint convertToPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToPoint()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoPointEPSNative.jni_ConvertToPoint(this.getHandle());
        if (l != 0L) {
            GeoPoint geoPoint = new GeoPoint(l);
            geoPoint.setIsDisposable(true);
            return geoPoint;
        }
        return null;
    }

    public GeoPoint3D convertToPoint3D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertToPoint3D()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoPointEPSNative.jni_ConvertToPoint3D(this.getHandle());
        if (l != 0L) {
            GeoPoint3D geoPoint3D = new GeoPoint3D(l);
            geoPoint3D.setIsDisposable(true);
            return geoPoint3D;
        }
        return null;
    }
}

