/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoParametricSurfaceMeshNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Point3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class GeoParametricSurfaceMesh
extends InternalHandleDisposable {
    public GeoParametricSurfaceMesh() {
        long l = GeoParametricSurfaceMeshNative.jni_New1();
        this.setHandle(l, true);
    }

    public GeoParametricSurfaceMesh(GeoParametricSurfaceMesh surfaceMesh) {
        if (surfaceMesh == null) {
            String string = InternalResource.loadString("GeoParametricSurfaceMesh", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (surfaceMesh.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoParametricSurfaceMesh", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoParametricSurfaceMeshNative.jni_Clone(surfaceMesh.getHandle(), this.getHandle());
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoParametricSurfaceMesh", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoParametricSurfaceMeshNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public Point2D getURange() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getURange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoParametricSurfaceMeshNative.jni_GetURange(this.getHandle());
        if (dArray != null && dArray.length == 2) {
            return new Point2D(dArray[0], dArray[1]);
        }
        return null;
    }

    public void setURange(Point2D uRange) {
        if (uRange == null) {
            return;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setURange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{uRange.getX(), uRange.getY()};
        GeoParametricSurfaceMeshNative.jni_SetURange(this.getHandle(), dArray);
    }

    public Point2D getVRange() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoParametricSurfaceMeshNative.jni_GetVRange(this.getHandle());
        if (dArray != null && dArray.length == 2) {
            return new Point2D(dArray[0], dArray[1]);
        }
        return null;
    }

    public void setVRange(Point2D vRange) {
        if (vRange == null) {
            return;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVRange", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{vRange.getX(), vRange.getY()};
        GeoParametricSurfaceMeshNative.jni_SetVRange(this.getHandle(), dArray);
    }

    public double getUStep() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUStep", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricSurfaceMeshNative.jni_GetUStep(this.getHandle());
    }

    public void setUStep(double uStep) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUStep", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricSurfaceMeshNative.jni_SetUStep(this.getHandle(), uStep);
    }

    public double getVStep() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVStep", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricSurfaceMeshNative.jni_GetVStep(this.getHandle());
    }

    public void setVStep(double vStep) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVStep", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricSurfaceMeshNative.jni_SetVStep(this.getHandle(), vStep);
    }

    public String getMathExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMathExpression", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricSurfaceMeshNative.jni_GetMathExpression(this.getHandle());
    }

    public void setMathExpression(String mathExpression) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMathExpression", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricSurfaceMeshNative.jni_SetMathExpression(this.getHandle(), mathExpression);
    }

    public boolean hasW() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hasW", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoParametricSurfaceMeshNative.jni_GetHasW(this.getHandle());
    }

    public void setHasW(boolean hasW) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHasW", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoParametricSurfaceMeshNative.jni_SetHasW(this.getHandle(), hasW);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoParametricSurfaceMeshNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }

    public HashMap<String, Double> getConstantTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getConstantTable", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String[] stringArray = GeoParametricSurfaceMeshNative.jni_GetConstantTable(this.getHandle());
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        if (stringArray == null || stringArray.length == 0) {
            return hashMap;
        }
        for (int i = 0; i < stringArray.length / 2; ++i) {
            String string = stringArray[2 * i];
            double d2 = Double.valueOf(stringArray[2 * i + 1]);
            hashMap.put(string, d2);
        }
        return hashMap;
    }

    public void setConstantTable(HashMap<String, Double> tableValue) {
        if (tableValue == null) {
            return;
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setConstantTable", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        Set<String> set = tableValue.keySet();
        for (String object2 : set) {
            arrayList.add(object2);
            arrayList2.add(tableValue.get(object2));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        double[] dArray = arrayList2.stream().mapToDouble(Double::valueOf).toArray();
        GeoParametricSurfaceMeshNative.jni_SetConstantTable(this.getHandle(), stringArray, dArray);
    }
}

