/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoNorthArrowNative;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.NorthArrowLanguageType;
import com.supermap.data.NorthArrowStyleType;
import com.supermap.data.Rectangle2D;
import java.io.File;

public class GeoNorthArrow
extends Geometry {
    private int a;
    private GeoStyle b;

    public GeoNorthArrow() {
        long l = GeoNorthArrowNative.jni_New();
        this.setHandle(l, true);
        this.a = -1;
    }

    public GeoNorthArrow(GeoNorthArrow geoNorthArrow) {
        if (geoNorthArrow == null) {
            String string = InternalResource.loadString("geoNorthArrow", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandleDisposable.getHandle(geoNorthArrow);
        if (l == 0L) {
            String string = InternalResource.loadString("geoNorthArrow", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoNorthArrowNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.a = geoNorthArrow.getBindingGeoMapID();
        InternalHandleDisposable.makeSureNativeObjectLive(geoNorthArrow);
    }

    public GeoNorthArrow(NorthArrowStyleType styleType, Rectangle2D bounds, double rotation) {
        if (styleType == null) {
            String string = InternalResource.loadString("styleType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsHeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoNorthArrowNative.jni_New2(styleType.value(), bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop(), rotation);
        this.setHandle(l, true);
    }

    public GeoNorthArrow(String imageFile, Rectangle2D bounds, double rotation) {
        File file = new File(imageFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("imageFile", "GeoNorthArrow_TheImageFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsHeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoNorthArrowNative.jni_New3(imageFile, bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop(), rotation);
        this.setHandle(l, true);
        this.setStyleType(NorthArrowStyleType.IMAGEFILE);
    }

    public GeoNorthArrow(int geoMapID, NorthArrowStyleType styleType, Rectangle2D bounds) {
        if (styleType == null) {
            String string = InternalResource.loadString("styleType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsHeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoNorthArrowNative.jni_New2(styleType.value(), bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop(), 0.0);
        this.setHandle(l, true);
        this.a = geoMapID;
    }

    public GeoNorthArrow(int geoMapID, String imageFile, Rectangle2D bounds) {
        File file = new File(imageFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("imageFile", "GeoNorthArrow_TheImageFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getHeight() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsHeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (bounds.getWidth() <= 0.0) {
            String string = InternalResource.loadString("rect", "GeoNorthArrow_BoundsWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoNorthArrowNative.jni_New3(imageFile, bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop(), 0.0);
        this.setHandle(l, true);
        this.a = geoMapID;
        this.setStyleType(NorthArrowStyleType.IMAGEFILE);
    }

    GeoNorthArrow(long handle) {
        this.setHandle(handle, false);
    }

    public NorthArrowStyleType getStyleType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoNorthArrowNative.jni_GetStyleType(this.getHandle());
        return (NorthArrowStyleType)Enum.parse(NorthArrowStyleType.class, n);
    }

    public void setStyleType(NorthArrowStyleType northArrowStyleType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyleType(NorthArrowStyleType northArrowStyleType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (northArrowStyleType == null) {
            String string = InternalResource.loadString("northArrowStyleType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = northArrowStyleType.value();
        GeoNorthArrowNative.jni_SetStyleType(this.getHandle(), n);
    }

    public NorthArrowLanguageType getLanguageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyleType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoNorthArrowNative.jni_GetLanguageType(this.getHandle());
        return (NorthArrowLanguageType)Enum.parse(NorthArrowLanguageType.class, n);
    }

    public void setLanguageType(NorthArrowLanguageType northArrowLanguageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLanguageType(NorthArrowLanguageType northArrowLanguageType)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (northArrowLanguageType == null) {
            String string = InternalResource.loadString("northArrowLanguageType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = northArrowLanguageType.value();
        GeoNorthArrowNative.jni_SetLanguageType(this.getHandle(), n);
    }

    public int getBindingGeoMapID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBindingGeoMapID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setBindingGeoMapID(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBindingGeoMapID(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a = value;
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoNorthArrowNative.jni_GetRotation(this.getHandle());
    }

    public void setRotation(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoNorthArrowNative.jni_SetRotation(this.getHandle(), value);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoNorthArrowNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoNorthArrow_BoundsWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoNorthArrowNative.jni_SetWidth(this.getHandle(), value);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoNorthArrowNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0.0) {
            String string = InternalResource.loadString("value", "GeoNorthArrow_BoundsHeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoNorthArrowNative.jni_SetHeight(this.getHandle(), value);
    }

    public String getImageFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoNorthArrowNative.jni_GetImageFile(this.getHandle());
    }

    public void setImageFile(String imageFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageFile(String imageFile)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        File file = new File(imageFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("imageFile", "GeoNorthArrow_TheImageFileIsNotExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoNorthArrowNative.jni_SetImageFile(this.getHandle(), imageFile);
    }

    public boolean setGeoReference(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setGeoReference(Rectangle2D bounds)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoNorthArrowNative.jni_SetGeoReference(this.getHandle(), bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop());
    }

    public double getMeridianAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMeridianAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoNorthArrowNative.jni_GetMeridianAngle(this.getHandle());
    }

    public void setMeridianAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMeridianAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoNorthArrowNative.jni_SetMeridianAngle(this.getHandle(), value);
    }

    public double getMagnetAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMagnetAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoNorthArrowNative.jni_GetMagnetAngle(this.getHandle());
    }

    public void setMagnetAngle(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMagnetAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoNorthArrowNative.jni_SetMagnetAngle(this.getHandle(), value);
    }

    @Override
    public GeoStyle getStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.b == null && (l = GeoNorthArrowNative.jni_GetStyle(this.getHandle())) != 0L) {
            this.b = GeoStyle.createInstance(l);
        }
        return this.b;
    }

    @Override
    public void setStyle(GeoStyle value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.getHandle() == 0L) {
            String string = InternalResource.loadString("value", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = value.clone();
        GeoNorthArrowNative.jni_SetStyle(this.getHandle(), geoStyle.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(value);
    }

    @Override
    public GeoNorthArrow clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoNorthArrow(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoNorthArrowNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.b != null) {
            this.b.clearHandle();
            this.b = null;
        }
        this.setHandle(0L);
    }
}

