/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoEllipticRingNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoEllipticRing
extends Geometry3D {
    public GeoEllipticRing() {
        long l = GeoEllipticRingNative.jni_New1();
        this.setHandle(l, true);
    }

    public GeoEllipticRing(GeoEllipticRing geoEllipticRing) {
        if (geoEllipticRing == null) {
            String string = InternalResource.loadString("GeoEllipticRing", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoEllipticRing.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoEllipticRing", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipticRingNative.jni_Clone(geoEllipticRing.getHandle(), this.getHandle());
    }

    public GeoEllipticRing(Point3D position, double pipeRadius, double semimajorAxis, double semiminorAxis) {
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        long l = GeoEllipticRingNative.jni_New3(dArray, pipeRadius, semimajorAxis, semiminorAxis);
        this.setHandle(l, true);
    }

    @Override
    public GeoEllipticRing clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEllipticRing(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("GeoEllipticRing", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEllipticRingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getPipeRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPipeRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticRingNative.jni_GetPipeRadius(this.getHandle());
    }

    public void setPipeRadius(double pipeRadius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPipeRadius", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticRingNative.jni_SetPipeRadius(this.getHandle(), pipeRadius);
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemimajorAxis", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticRingNative.jni_GetSemiMajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double semimajorAxis) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemimajorAxis", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticRingNative.jni_SetSemiMajorAxis(this.getHandle(), semimajorAxis);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemiminorAxis", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticRingNative.jni_GetSemiMinorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double semiminorAxis) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemiminorAxis", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticRingNative.jni_SetSemiMinorAxis(this.getHandle(), semiminorAxis);
    }

    public Point3D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCenter", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = GeoEllipticRingNative.jni_GetCenter(this.getHandle());
        if (dArray != null && dArray.length == 3) {
            Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
            return point3D;
        }
        return null;
    }
}

