/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetImage;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.ElevationDataNative;
import com.supermap.data.ElevationDataType;
import com.supermap.data.EngineType;
import com.supermap.data.FixedElevationData;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.SRTMV4;
import com.supermap.data.UserDEM;
import java.io.File;

public abstract class ElevationData
extends InternalHandleDisposable {
    protected ElevationDataType m_eType;
    protected long m_ugcRawPointerHandle = 0L;

    public ElevationDataType getType() {
        return this.m_eType;
    }

    public static ElevationData fromUGC(long handle) {
        if (handle == 0L) {
            return null;
        }
        int n = ElevationDataNative.jni_GetType(handle);
        ElevationDataType elevationDataType = ElevationDataType.valueOf(n);
        if (elevationDataType == ElevationDataType.FIXEDELEVATION) {
            return new FixedElevationData(handle);
        }
        if (elevationDataType == ElevationDataType.SRTMV4) {
            return new SRTMV4(handle);
        }
        if (elevationDataType == ElevationDataType.USERDEM) {
            return new UserDEM(handle);
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.getIsDisposable() && this.getHandle() != 0L) {
            ElevationDataNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.m_ugcRawPointerHandle = 0L;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().toString().equals(obj.getClass().toString())) {
            return false;
        }
        ElevationData elevationData = (ElevationData)obj;
        return this.m_ugcRawPointerHandle == elevationData.m_ugcRawPointerHandle;
    }

    public int hashCode() {
        return (int)(this.m_ugcRawPointerHandle ^ this.m_ugcRawPointerHandle >>> 32);
    }

    public String getGeoidFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ElevationData", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        return ElevationDataNative.jni_GetGeoidFile(this.getHandle());
    }

    public boolean isUseGeoid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ElevationData", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        return ElevationDataNative.jni_IsUseGeoid(this.getHandle());
    }

    public void setGeoidFile(String geoidFile) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ElevationData", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        if (geoidFile == null) {
            String string = InternalResource.loadString("geoidFile", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        File file = new File(geoidFile);
        if (!file.exists()) {
            String string = InternalResource.loadString("geoidFile", "Global_FileNotExists", "data_resources");
            throw new NullPointerException(string);
        }
        DatasourceConnectionInfo datasourceConnectionInfo = new DatasourceConnectionInfo();
        datasourceConnectionInfo.setEngineType(EngineType.IMAGEPLUGINS);
        datasourceConnectionInfo.setServer(geoidFile);
        Datasource datasource = new Datasource(EngineType.IMAGEPLUGINS);
        if (!datasource.open(datasourceConnectionInfo)) {
            String string = InternalResource.loadString(geoidFile, "String_OpenImageFileAsDatasourceFailed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource.getDatasets().getCount() == 0) {
            datasource.close();
            String string = InternalResource.loadString(geoidFile, "String_InvalidImagePluginDatasource", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetImage datasetImage = (DatasetImage)datasource.getDatasets().get(0);
        if (datasetImage == null) {
            datasource.close();
            String string = InternalResource.loadString(geoidFile, "String_InvalidImagePluginDatasource", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetImage.getBandCount() != 1) {
            datasource.close();
            String string = InternalResource.loadString(geoidFile, "String_ElevationDatasetMustOneBand", "data_resources");
            throw new IllegalArgumentException(string);
        }
        datasource.close();
        ElevationDataNative.jni_SetGeoidFile(this.getHandle(), geoidFile);
    }

    public void setUseGeoid(boolean isUseGeoid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ElevationData", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        ElevationDataNative.jni_SetUseGeoid(this.getHandle(), isUseGeoid);
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ElevationData", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new NullPointerException(string);
        }
        return ElevationDataNative.jni_ToXML(this.getHandle());
    }

    public static ElevationData fromXML(String xml) {
        if (xml == null || xml.isEmpty()) {
            String string = InternalResource.loadString("xml", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ElevationDataNative.jni_FromXML(xml);
        if (l == 0L) {
            String string = InternalResource.loadString("xml", "String_ElevationDataParseXMLFailed", "data_resources");
            throw new RuntimeException(string);
        }
        int n = ElevationDataNative.jni_GetType(l);
        ElevationDataType elevationDataType = ElevationDataType.valueOf(n);
        if (elevationDataType == null) {
            String string = InternalResource.loadString("ElevationDataType", "Global_EnumValueIsError", "data_resources");
            throw new RuntimeException(string);
        }
        ElevationData elevationData = null;
        if (elevationDataType == ElevationDataType.FIXEDELEVATION) {
            elevationData = new FixedElevationData(l);
        } else if (elevationDataType == ElevationDataType.SRTMV4) {
            elevationData = new SRTMV4(l);
        } else if (elevationDataType == ElevationDataType.USERDEM) {
            elevationData = new UserDEM(l);
        }
        return elevationData;
    }
}

