/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Version;
import com.supermap.data.VersionChange;
import com.supermap.data.VersionChangesNative;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class VersionChanges
extends InternalHandleDisposable {
    protected Version m_version = null;

    protected VersionChanges(long handle, Version version) {
        this.setHandle(handle, true);
        this.m_version = version;
    }

    public List<VersionChange> getAllVersionChange() {
        this.a();
        LinkedList<VersionChange> linkedList = new LinkedList<VersionChange>();
        long[] lArray = VersionChangesNative.jni_GetAllVersionChanges(this.getHandle());
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= 0L) continue;
            linkedList.add(new VersionChange(lArray[i], this));
        }
        return linkedList;
    }

    public VersionChange getVersionChange(String datasetName) {
        this.a();
        long l = VersionChangesNative.jni_GetVersionChange(this.getHandle(), datasetName);
        if (l > 0L) {
            return new VersionChange(l, this);
        }
        return null;
    }

    public boolean resetVersionChange(String datasetName) {
        this.a();
        return VersionChangesNative.jni_ResetVersionChange(this.getHandle(), datasetName);
    }

    public boolean resetVersionChangeByTime(String datasetName, Date resetDate) {
        this.a();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(resetDate);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = String.format("%d-%d-%d %d:%d:%d", n, n2, n3, n4, n5, n6);
        return VersionChangesNative.jni_ResetVersionChangeByTime(this.getHandle(), datasetName, string);
    }

    private void a() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    @Override
    public void dispose() {
        this.dispose(() -> {
            VersionChangesNative.jni_Delete(this.getHandle());
            this.clearHandle();
        });
    }
}

