/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MaterialNative;
import java.awt.Color;

public class Material
extends InternalHandleDisposable {
    public Material() {
        long l = MaterialNative.jni_New();
        this.setHandle(l, true);
    }

    public Material(Material material) {
        this(material, true);
    }

    protected Material(Material material, boolean dispose) {
        if (material == null) {
            String string = InternalResource.loadString("Material", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (material.getHandle() == 0L) {
            String string = InternalResource.loadString("Material", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = MaterialNative.jni_Clone(material.getHandle());
        this.setHandle(l, dispose);
    }

    public boolean toStreamFile(String strStreamFile) {
        return MaterialNative.jni_ToStreamFile(this.getHandle(), strStreamFile);
    }

    protected Material(long handle) {
        this.setHandle(handle, true);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MaterialNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public Color getAmbient() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAmbient", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetAmbient(this.getHandle()), true);
        return color;
    }

    public void setAmbient(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAmbient", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setAmbient", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetAmbient(this.getHandle(), value.getRGB());
    }

    public Color getDiffuse() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDiffuse", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetDiffuse(this.getHandle()), true);
        return color;
    }

    public void setDiffuse(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDiffuse", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setDiffuse", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetDiffuse(this.getHandle(), value.getRGB());
    }

    public Color getSpecular() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpecular", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetSpecular(this.getHandle()), true);
        return color;
    }

    public void setSpecular(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecular", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setSpecular", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetSpecular(this.getHandle(), value.getRGB());
    }

    public Color getEmission() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEmission", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(MaterialNative.jni_GetEmission(this.getHandle()), true);
        return color;
    }

    public void setEmission(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmission", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setEmission", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetEmission(this.getHandle(), value.getRGB());
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MaterialNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setName", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetName(this.getHandle(), value);
    }

    public double getShininess() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCameraDistanceZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MaterialNative.jni_GetShininess(this.getHandle());
    }

    public void setShininess(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCameraDistanceZ(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MaterialNative.jni_SetShininess(this.getHandle(), value);
    }

    public String getTextureFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTgetTextureFile()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return MaterialNative.jni_GetTextureFile(this.getHandle());
    }

    public void setTextureFile(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTgetTextureFile(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("setTgetTextureFile", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MaterialNative.jni_SetTextureFile(this.getHandle(), value);
    }
}

