/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BlockSizeOption;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVolume;
import com.supermap.data.DatasetVolumeInfoNative;
import com.supermap.data.EncodeType;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalInvalidState;
import com.supermap.data.InternalResource;
import com.supermap.data.PixelFormat;
import com.supermap.data.Rectangle2D;

public class DatasetVolumeInfo
extends InternalHandleDisposable {
    private boolean a = false;

    public DatasetVolumeInfo() {
        this.setHandle(DatasetVolumeInfoNative.jni_New(), true);
        this.a();
    }

    public DatasetVolumeInfo(DatasetVolumeInfo datasetVolumeInfo) {
        if (datasetVolumeInfo == null) {
            String string = InternalResource.loadString("datasetVolumeInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasetVolumeInfo.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetVolumeInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetVolumeInfoNative.jni_Clone(datasetVolumeInfo.getHandle());
        this.setHandle(l, true);
        InternalHandleDisposable.makeSureNativeObjectLive(datasetVolumeInfo);
    }

    public DatasetVolumeInfo(String name, int width, int height, PixelFormat pixelFormat, EncodeType encodeType) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (pixelFormat == null) {
            String string = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (pixelFormat.equals(PixelFormat.RGB) || pixelFormat.equals(PixelFormat.RGBA)) {
            String string = InternalResource.loadString("pixelFormat", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(DatasetVolumeInfoNative.jni_New(), true);
        this.a();
        this.setName(name);
        this.setWidth(width);
        this.setHeight(height);
        this.setPixelFormat(pixelFormat);
        this.setEncodeType(encodeType);
    }

    public DatasetVolumeInfo(String name, int width, int height, PixelFormat pixelFormat, EncodeType encodeType, BlockSizeOption option) {
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (pixelFormat == null) {
            String string = InternalResource.loadString("pixelFormat", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (pixelFormat.equals(PixelFormat.RGB) || pixelFormat.equals(PixelFormat.RGBA)) {
            String string = InternalResource.loadString("pixelFormat", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.setHandle(DatasetVolumeInfoNative.jni_New(), true);
        this.a();
        this.setName(name);
        this.setWidth(width);
        this.setHeight(height);
        this.setPixelFormat(pixelFormat);
        this.setBlockSizeOption(option);
        this.setEncodeType(encodeType);
    }

    public DatasetVolumeInfo(String name, DatasetVolume templateDataset) {
        if (templateDataset == null) {
            String string = InternalResource.loadString("templateDataset", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = templateDataset.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("templateDataset", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = DatasetVolumeInfoNative.jni_New2(l);
        this.setHandle(l2, true);
        this.setName(name);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeInfoNative.jni_GetName(this.getHandle());
    }

    public void setName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        InternalInvalidState internalInvalidState = Dataset.b(value);
        if (internalInvalidState != null) {
            String string = "";
            if (internalInvalidState.equals(InternalInvalidState.ISEMPTY)) {
                string = "Dataset_NameIsEmpty";
            } else if (internalInvalidState.equals(InternalInvalidState.AGAINSYSTEMNAME)) {
                string = "Dataset_NameAgainstSys";
            } else if (internalInvalidState.equals(InternalInvalidState.BEYONDLIMIT)) {
                string = "Dataset_NameBeyondLimit";
            } else if (internalInvalidState.equals(InternalInvalidState.INVALIDCHAR)) {
                string = "Dataset_NameIncludeInvalidChar";
            } else if (internalInvalidState.equals(InternalInvalidState.PREFIXERROR)) {
                string = "Dataset_NameErrorPrefix";
            }
            String string2 = InternalResource.loadString("value", string, "data_resources");
            throw new IllegalArgumentException(string2);
        }
        DatasetVolumeInfoNative.jni_SetName(this.getHandle(), value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        DatasetVolumeInfoNative.jni_GetBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public void setBounds(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVolumeInfoNative.jni_SetBounds(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeInfoNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVolumeInfoNative.jni_SetWidth(this.getHandle(), value);
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeInfoNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "DatasetGrid_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVolumeInfoNative.jni_SetHeight(this.getHandle(), value);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVolumeInfoNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public void setPixelFormat(PixelFormat value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (value.equals(PixelFormat.RGB) || value.equals(PixelFormat.RGBA)) {
            String string = InternalResource.loadString("value", "DatasetGridInfo_UnSupportedPixelFormat", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVolumeInfoNative.jni_SetPixelFormat(this.getHandle(), value.getUGCValue());
    }

    public BlockSizeOption getBlockSizeOption() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetVolumeInfoNative.jni_GetBlockSize(this.getHandle());
        return (BlockSizeOption)Enum.parseUGCValue(BlockSizeOption.class, n);
    }

    public void setBlockSizeOption(BlockSizeOption option) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVolumeInfoNative.jni_SetBlockSize(this.getHandle(), option.getUGCValue());
    }

    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.getSliceCount() == 0) {
            return EncodeType.NONE;
        }
        int n = DatasetVolumeInfoNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)Enum.parseUGCValue(EncodeType.class, n);
    }

    public void setEncodeType(EncodeType encodeType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        DatasetVolumeInfoNative.jni_SetEncodeType(this.getHandle(), encodeType.getUGCValue());
    }

    public int getSliceCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetVolumeInfoNative.jni_GetSliceCount(this.getHandle());
    }

    public void setSliceCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "DatasetImage_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetVolumeInfoNative.jni_SetSliceCount(this.getHandle(), value);
    }

    public boolean isMultiSlice() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name = ");
        stringBuffer.append(this.getName());
        stringBuffer.append(",Bounds = {");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append("},Width = ");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(",Height = ");
        stringBuffer.append(this.getHeight());
        stringBuffer.append(",PixelFormat = ");
        stringBuffer.append(this.getPixelFormat().name());
        stringBuffer.append(",BlockSize = ");
        stringBuffer.append(this.getBlockSizeOption());
        stringBuffer.append(",EncodeType = ");
        stringBuffer.append(this.getEncodeType().name());
        stringBuffer.append(",IsMultiSlice = ");
        stringBuffer.append(this.isMultiSlice());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            DatasetVolumeInfoNative.jni_Delete(super.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    void a() {
        if (this.getHandle() != 0L) {
            DatasetVolumeInfoNative.jni_Reset(this.getHandle());
        }
    }
}

