/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingDGNNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;
import com.supermap.data.conversion.a;
import java.io.File;

public class ImportSettingDGN
extends ImportSetting {
    public ImportSettingDGN() {
        long l = ImportSettingDGNNative.jni_New();
        this.setHandle(l, true);
        super.a(com.supermap.data.conversion.a.a);
    }

    public ImportSettingDGN(ImportSettingDGN importSettingDGN) {
        if (importSettingDGN == null) {
            String string = InternalResource.loadString("ImportSettingDGN", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingDGN);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingDGN", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingDGNNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingDGN.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingDGN.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingDGN.getTargetPrjCoordSys());
        super.a(com.supermap.data.conversion.a.a);
        this.setImportEmptyDataset(importSettingDGN.isImportEmptyDataset());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingDGN));
    }

    public ImportSettingDGN(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        super.a(com.supermap.data.conversion.a.a);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingDGN(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        super.a(com.supermap.data.conversion.a.a);
    }

    public ImportSettingDGN(String sourceFilePath, Datasource targetDatasource, boolean importingAsCAD) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        this.setImportingAsCAD(importingAsCAD);
        super.a(com.supermap.data.conversion.a.a);
    }

    public ImportSettingDGN(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo, boolean importingAsCAD) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        this.setImportingAsCAD(importingAsCAD);
        super.a(com.supermap.data.conversion.a.a);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public void setImportingAsCAD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportingAsCAD(this.getHandle(), value);
    }

    public boolean isImportingCellAsPoint() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingSymbolBlockAsPoint()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportingCellAsPoint(this.getHandle());
    }

    public void setImportingCellAsPoint(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingSymbolBlockAsPoint(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportingCellAsPoint(this.getHandle(), value);
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ImportSettingDGNNative.jni_GetSpatialIndex(this.getHandle());
        return InternalSpatialIndexInfo.createInstance(l);
    }

    public void setSpatialIndex(SpatialIndexInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndexType value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetSpatialIndex(this.getHandle(), com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)value));
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public boolean isImportingByLayer() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingByLayer()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportingByLayer(this.getHandle());
    }

    public void setImportingByLayer(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingByLayer(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportingByLayer(this.getHandle(), value);
    }

    public String getStyleMappingTableFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStyleMapFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingDGNNative.jni_GetStyleMapFilePath(this.getHandle());
    }

    public void setStyleMappingTableFile(String path) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStyleMapFilePath(String path)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.trim().length() == 0) {
            String string = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(path);
        if (!file.exists()) {
            String string = InternalResource.loadString(file.getAbsolutePath(), "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetStyleMapFilePath(this.getHandle(), file.getPath());
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingDGNNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingDGNNative.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingDGNNative.jni_IsImportEmptyDT(this.getHandle());
    }
}

