/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.CAFlushedEvent;
import com.supermap.analyst.spatialanalyst.CAFlushedListener;
import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.MCECellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.MultiCriteriaEvaluationCANative;
import com.supermap.analyst.spatialanalyst.PrincipalComponentAnalysisCANative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.PixelFormat;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;

public class MCECellularAutomata
extends InternalHandleDisposable {
    private static License a;
    private static transient Vector b;
    private static transient Vector c;

    public MCECellularAutomata() {
        long l = MultiCriteriaEvaluationCANative.jni_New();
        this.setHandle(l, true);
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            // empty if block
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            MultiCriteriaEvaluationCANative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    private void a(CellularAutomataParameter cellularAutomataParameter) {
        long l = super.getHandle();
        long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)cellularAutomataParameter.getCellGrid());
        DatasetGrid[] datasetGridArray = cellularAutomataParameter.getSpatialVariableGrids();
        long[] lArray = new long[datasetGridArray.length];
        for (int i = 0; i < datasetGridArray.length; ++i) {
            lArray[i] = InternalHandleSpatialanalyst.getHandle((InternalHandle)datasetGridArray[i]);
        }
        long l3 = 0L;
        if (cellularAutomataParameter.getOutputDataSource() != null) {
            l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)cellularAutomataParameter.getOutputDataSource());
        }
        PrincipalComponentAnalysisCANative.jni_setCellularAutomataParameter(l, l2, lArray, l3, cellularAutomataParameter.getOutputDatasetName(), cellularAutomataParameter.IsSave(), cellularAutomataParameter.getSaveFrequency(), cellularAutomataParameter.getFlushFrequency(), cellularAutomataParameter.getSimulationCount(), cellularAutomataParameter.getFlushFilePathName(), cellularAutomataParameter.getIterations());
    }

    public double[] checkAHPConsistent(double[][] AHPComparisonMatrix) {
        if (AHPComparisonMatrix == null || AHPComparisonMatrix.length == 0) {
            String string = InternalResourceSpatialanalyst.loadString("AHPComparisonMatrix", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < AHPComparisonMatrix.length; ++i) {
            if (AHPComparisonMatrix[i] == null) {
                String string = InternalResourceSpatialanalyst.loadString("AHPComparisonMatrix[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (AHPComparisonMatrix.length == AHPComparisonMatrix[i].length) continue;
            String string = InternalResourceSpatialanalyst.loadString("AHPComparisonMatrix[" + i + "].length and AHPComparisonMatrix.length must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = MultiCriteriaEvaluationCANative.jni_checkAHPConsistent(super.getHandle(), AHPComparisonMatrix);
        if (dArray == null) {
            String string = InternalResourceSpatialanalyst.loadString("AHPComparisonMatrix", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return dArray;
    }

    public DatasetGrid mceCellularAutomata(Datasource outputDatasource, String outputDatasetName, MCECellularAutomataParameter parameter) {
        return this.mceCellularAutomata(outputDatasource, outputDatasetName, parameter, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetGrid mceCellularAutomata(Datasource outputDatasource, String outputDatasetName, MCECellularAutomataParameter parameter, SteppedListener ... listeners) {
        try {
            Object object;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            MCECellularAutomata.a();
            if (parameter == null) {
                String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            this.a(parameter);
            if (null == outputDatasource || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (outputDatasetName == null || outputDatasetName.trim().equalsIgnoreCase("")) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            this.a(parameter.getCellularAutomataParameter());
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)outputDatasource);
            long l2 = 0L;
            if (parameter.isCheckResult()) {
                l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter.getEndCellGrid());
            }
            Map<Integer, Boolean> map = parameter.getConversionRules();
            Object[] objectArray = map.keySet().toArray();
            int[] nArray = new int[map.size()];
            boolean[] blArray = new boolean[map.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                nArray[i] = (Integer)objectArray[i];
                blArray[i] = map.get(objectArray[i]);
            }
            String[] stringArray = new String[1];
            long l3 = MultiCriteriaEvaluationCANative.jni_mceCA(super.getHandle(), l, outputDatasetName, parameter.isCheckResult(), l2, parameter.getAHPComparisonMatrix(), parameter.getGlobalValue(), parameter.getLocalValue(), parameter.getAlpha(), nArray, blArray, parameter.getConversionTarget(), stringArray);
            DatasetGrid datasetGrid = null;
            if (l3 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l3, outputDatasource);
                InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
                object = MultiCriteriaEvaluationCANative.jni_getIterationResults(super.getHandle());
                if (object != null && ((DatasetGrid)object).length != 0) {
                    for (int i = 0; i < ((DatasetGrid)object).length; ++i) {
                        DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance((long)object[i], parameter.getCellularAutomataParameter().getOutputDataSource());
                        InternalDatasets.add(parameter.getCellularAutomataParameter().getOutputDataSource().getDatasets(), (Dataset)datasetGrid2);
                    }
                }
            } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                throw new RuntimeException(stringArray[0]);
            }
            object = datasetGrid;
            return object;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public double getKappa() {
        if (this.getHandle() == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("MultiCriteriaEvaluationCA", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return MultiCriteriaEvaluationCANative.jni_getKappa(super.getHandle());
    }

    private void a(MCECellularAutomataParameter mCECellularAutomataParameter) {
        if (mCECellularAutomataParameter == null) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        CellularAutomataParameter.CheckParameter(mCECellularAutomataParameter.getCellularAutomataParameter());
        if (mCECellularAutomataParameter.isCheckResult()) {
            if (null == mCECellularAutomataParameter.getEndCellGrid() || 0L == InternalHandleSpatialanalyst.getHandle((InternalHandle)mCECellularAutomataParameter.getEndCellGrid())) {
                String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.getEndCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.BIT8 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.BIT16 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.BIT32 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.BIT64 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT1 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT4 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT8 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT16 && mCECellularAutomataParameter.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResourceSpatialanalyst.loadString("CellularAutomataParameter.getCellGrid()", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (null == mCECellularAutomataParameter.getAHPComparisonMatrix() || 0 == mCECellularAutomataParameter.getAHPComparisonMatrix().length) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.getAHPComparisonMatrix", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = this.checkAHPConsistent(mCECellularAutomataParameter.getAHPComparisonMatrix());
        if (dArray == null) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.geAHPComparisonMatrix", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (mCECellularAutomataParameter.getLocalValue() <= 0.0 || mCECellularAutomataParameter.getLocalValue() >= 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.getLocalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (mCECellularAutomataParameter.getGlobalValue() <= 0.0 || mCECellularAutomataParameter.getGlobalValue() >= 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.getGlobalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double d = mCECellularAutomataParameter.getGlobalValue() + mCECellularAutomataParameter.getLocalValue();
        if (d <= 0.0 || d > 1.0) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.getGlobalValue + MCECellularAutomataParameter.getLocalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (mCECellularAutomataParameter.getAlpha() <= 0 || mCECellularAutomataParameter.getAlpha() > 10) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.getAlpha", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (mCECellularAutomataParameter.getConversionRules() == null || mCECellularAutomataParameter.getConversionRules().size() == 0) {
            String string = InternalResourceSpatialanalyst.loadString("MCECellularAutomataParameter.getConversionRules()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "MCECellularAutomata";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static synchronized void addCAFlushedListener(CAFlushedListener l) {
        if (c == null) {
            c = new Vector();
        }
        if (!c.contains(l)) {
            c.add(l);
        }
    }

    public static synchronized void removeCAFlushedListener(CAFlushedListener l) {
        if (c != null && c.contains(l)) {
            c.remove(l);
        }
    }

    protected static void fireCAFlushed(CAFlushedEvent event) {
        if (c != null) {
            Vector vector = c;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CAFlushedListener)vector.elementAt(i)).CAFlushed(event);
            }
        }
    }

    static void CAFlushedCallBack(String strFlushFilePathName) {
        Object object = new Object();
        CAFlushedEvent cAFlushedEvent = new CAFlushedEvent(object, strFlushFilePathName);
        MCECellularAutomata.fireCAFlushed(cAFlushedEvent);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

