/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.InterpolationAnalystNative;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PixelFormat;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedHelper;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class Interpolator {
    private static License a;
    private static transient Vector b;
    private static GridAnalystSetting c;

    private Interpolator() {
        c = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return c;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            c = null;
            return;
        }
        if (c == null) {
            c = new GridAnalystSetting();
        }
        c.setBounds(gridAnalystSetting.getBounds());
        c.setBoundsType(gridAnalystSetting.getBoundsType());
        c.setCellSizeType(gridAnalystSetting.getCellSizeType());
        c.setCellSize(gridAnalystSetting.getCellSize());
        c.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        c.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        c.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        c.setValidRegion(gridAnalystSetting.getValidRegion());
        c.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static DatasetGrid interpolate(InterpolationParameter parameter, DatasetVector interpolatedPoint, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        return Interpolator.interpolate(parameter, interpolatedPoint, zValueFieldName, zValueScale, targetDatasource, targetDatasetName, pixelFormat, new SteppedListener[]{null});
    }

    public static DatasetGrid interpolate(InterpolationParameter parameter, DatasetVector interpolatedPoint, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat, SteppedListener ... listeners) {
        if (!interpolatedPoint.getType().equals((Object)DatasetType.POINT)) {
            String string = InternalResourceSpatialanalyst.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Recordset recordset = interpolatedPoint.getRecordset(false, CursorType.STATIC);
        DatasetGrid datasetGrid = Interpolator.interpolate(parameter, recordset, zValueFieldName, zValueScale, targetDatasource, targetDatasetName, pixelFormat, listeners);
        recordset.dispose();
        return datasetGrid;
    }

    public static DatasetGrid interpolate(InterpolationParameter parameter, Recordset interpolatedPointRecordset, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        DatasetGrid datasetGrid = Interpolator.interpolate(parameter, interpolatedPointRecordset, zValueFieldName, zValueScale, targetDatasource, targetDatasetName, pixelFormat, new SteppedListener[]{null});
        return datasetGrid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid interpolate(InterpolationParameter parameter, Recordset interpolatedPointRecordset, String zValueFieldName, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat, SteppedListener ... listeners) {
        try {
            SteppedHelper.addListeners((SteppedListener[])listeners);
            Interpolator.a();
            if (interpolatedPointRecordset == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)interpolatedPointRecordset) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("interpolatedPoint", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            DatasetVector datasetVector = interpolatedPointRecordset.getDataset();
            if (!datasetVector.getType().equals((Object)DatasetType.POINT)) {
                String string = InternalResourceSpatialanalyst.loadString("interpolatedPoint", "Interpolator_UnsupportedDatasetType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (pixelFormat.equals((Object)PixelFormat.BIT64)) {
                String string = InternalResourceSpatialanalyst.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (interpolatedPointRecordset.getFieldInfos().indexOf(zValueFieldName) == -1) {
                String string = InternalResourceSpatialanalyst.loadString("zValueFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            FieldInfo fieldInfo = interpolatedPointRecordset.getFieldInfos().get(zValueFieldName);
            if (fieldInfo == null || fieldInfo.getType() != FieldType.DOUBLE && fieldInfo.getType() != FieldType.INT16 && fieldInfo.getType() != FieldType.INT32 && fieldInfo.getType() != FieldType.INT64 && fieldInfo.getType() != FieldType.SINGLE) {
                String string = InternalResourceSpatialanalyst.loadString("zValueFieldName", "InterPolator_UnsupportedFieldType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (targetDatasource == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource) == 0L) {
                if (c == null || c.getOutputDatasource() == null) {
                    String string = InternalResourceSpatialanalyst.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new NullPointerException(string);
                }
                targetDatasource = c.getOutputDatasource();
            }
            if (targetDatasetName == null) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (c != null && c.getGridOutputNamePrefix() != null) {
                targetDatasetName = c.getGridOutputNamePrefix() + targetDatasetName;
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (parameter.getBounds().isEmpty() && c != null && !c.getBounds().isEmpty()) {
                parameter.setBounds(c.getBounds());
            }
            boolean bl = false;
            double d = parameter.getResolution();
            if (Toolkit.isZero((double)parameter.getResolution()) || parameter.getResolution() < 0.0) {
                bl = true;
                if (c != null && !Toolkit.isZero((double)c.getCellSize())) {
                    parameter.setResolution(c.getCellSize());
                } else {
                    double d2 = Math.min(parameter.getBounds().getHeight(), parameter.getBounds().getWidth());
                    parameter.setResolution(d2 / 500.0);
                }
            }
            boolean bl2 = true;
            if (c != null) {
                bl2 = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl2 = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)parameter);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)interpolatedPointRecordset);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l4 = InterpolationAnalystNative.jni_Interpolate(l, l2, zValueFieldName, zValueScale, l3, targetDatasetName, InternalEnum.getUGCValue((Enum)pixelFormat), bl2);
            if (bl) {
                parameter.setResolution(d);
            }
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)parameter));
            InternalHandleDisposable.makeSureNativeObjectLive((Object)interpolatedPointRecordset);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static DatasetGrid interpolate(InterpolationParameter paramerter, Point2D[] points, double[] values, PrjCoordSys prjCoordSys, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat) {
        return Interpolator.interpolate(paramerter, points, values, prjCoordSys, zValueScale, targetDatasource, targetDatasetName, pixelFormat, new SteppedListener[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetGrid interpolate(InterpolationParameter paramerter, Point2D[] points, double[] values, PrjCoordSys prjCoordSys, double zValueScale, Datasource targetDatasource, String targetDatasetName, PixelFormat pixelFormat, SteppedListener ... listeners) {
        try {
            boolean bl;
            SteppedHelper.addListeners((SteppedListener[])listeners);
            if (pixelFormat.equals((Object)PixelFormat.BIT64)) {
                String string = InternalResourceSpatialanalyst.loadString("pixelFormat", "InterPolator_UnsupportedPixelFormat", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (points.length < 1) {
                String string = InternalResourceSpatialanalyst.loadString("points", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (values.length < 1) {
                String string = InternalResourceSpatialanalyst.loadString("values", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (points.length != values.length) {
                String string = InternalResourceSpatialanalyst.loadString("points values", "PointsCount_MustEqual_ValuesCount", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (targetDatasetName == null) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
                String string = InternalResourceSpatialanalyst.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (zValueScale == 0.0) {
                String string = InternalResourceSpatialanalyst.loadString("zValueScale", "CanNotBeZero", "spatialanalyst_resources");
                throw new NullPointerException(string);
            }
            if (prjCoordSys == null || InternalHandleSpatialanalyst.getHandle((InternalHandle)prjCoordSys) == 0L) {
                String string = InternalResourceSpatialanalyst.loadString("prjCoordSys", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            double[] dArray = new double[points.length];
            double[] dArray2 = new double[points.length];
            for (bl = false; bl < values.length; bl += 1) {
                dArray[bl] = points[bl].x;
                dArray2[bl] = points[bl].y;
            }
            bl = true;
            if (c != null) {
                bl = c.isShowProgress();
            }
            if (listeners == null || listeners.length == 0) {
                bl = false;
            }
            long l = InternalHandleSpatialanalyst.getHandle((InternalHandle)paramerter);
            long l2 = InternalHandleSpatialanalyst.getHandle((InternalHandle)targetDatasource);
            long l3 = InternalHandleSpatialanalyst.getHandle((InternalHandle)prjCoordSys);
            long l4 = InterpolationAnalystNative.jni_Interpolate2(l, dArray, dArray2, values, l3, zValueScale, l2, targetDatasetName, InternalEnum.getUGCValue((Enum)pixelFormat), bl);
            DatasetGrid datasetGrid = null;
            if (l4 != 0L) {
                datasetGrid = InternalDatasetGrid.createInstance(l4, targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            }
            InternalHandleDisposable.makeSureNativeObjectLive((Object)l3);
            DatasetGrid datasetGrid2 = datasetGrid;
            return datasetGrid2;
        }
        finally {
            SteppedHelper.removeListeners((SteppedListener[])listeners);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (b == null) {
            b = new Vector();
        }
        if (!b.contains(l)) {
            b.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (b != null && b.contains(l)) {
            b.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (b != null) {
            Vector vector = b;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Interpolate";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        SteppedHelper.fire((Collection)b, (SteppedEvent)steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        int n = -1;
        Object object = a;
        synchronized (object) {
            n = a.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        a = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

