/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.GridHistogramNative;
import com.supermap.analyst.spatialanalyst.HistogramSegmentInfo;
import com.supermap.analyst.spatialanalyst.InternalHandleSpatialanalyst;
import com.supermap.analyst.spatialanalyst.InternalResourceSpatialanalyst;

public class GridHistogram
extends InternalHandleSpatialanalyst {
    private long a;

    protected GridHistogram(long ugcHandle) {
        this.a = ugcHandle;
    }

    public int getGroupCount() {
        if (this.a == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = GridHistogramNative.jni_GetGroupCount(this.a);
        return n;
    }

    public void setGroupCount(int count) {
        if (this.a == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (count <= 0) {
            String string = InternalResourceSpatialanalyst.loadString("GroupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GridHistogramNative.jni_SetGroupCount(this.a, count);
    }

    public int[] getFrequencies() {
        if (this.a == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = GridHistogramNative.jni_GetFrequencies(this.a);
        return nArray;
    }

    public HistogramSegmentInfo[] getSegmentInfos() {
        if (this.a == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int[] nArray = GridHistogramNative.jni_GetFrequencies(this.a);
        int n = nArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        GridHistogramNative.jni_GetSegmentInfos(this.a, dArray, dArray2, dArray3, dArray4);
        HistogramSegmentInfo[] histogramSegmentInfoArray = new HistogramSegmentInfo[n];
        for (int i = 0; i < n; ++i) {
            histogramSegmentInfoArray[i] = new HistogramSegmentInfo(dArray[i], dArray2[i], dArray3[i], dArray4[i], nArray[i]);
        }
        return histogramSegmentInfoArray;
    }

    public void dispose() {
        if (this.a == 0L) {
            String string = InternalResourceSpatialanalyst.loadString("handle", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        GridHistogramNative.jni_Dispose(this.a);
    }
}

