/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class Collection_UniqueFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    SimpleFeatureCollection previousFeatureCollection = null;
    Object unique = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Unique", FunctionNameImpl.parameter("unique", Object.class), FunctionNameImpl.parameter("expression", Object.class));

    public Collection_UniqueFunction() {
        super(NAME);
    }

    static CalcResult calculateUnique(SimpleFeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        UniqueVisitor uniqueVisitor = new UniqueVisitor(expression);
        collection.accepts((FeatureVisitor)uniqueVisitor, null);
        return uniqueVisitor.getResult();
    }

    public void setParameters(List args) {
        Expression expr = (Expression)args.get(0);
        expr = (Expression)expr.accept((ExpressionVisitor)new CollectionFeatureMemberFilterVisitor(), null);
        args.set(0, expr);
        super.setParameters(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        if (feature == null) {
            return new Integer(0);
        }
        SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)feature;
        Expression expr = this.getExpression(0);
        SimpleFeatureCollection simpleFeatureCollection = featureCollection;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.unique = null;
                try {
                    CalcResult result = Collection_UniqueFunction.calculateUnique(featureCollection, expr);
                    if (result != null) {
                        this.unique = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.unique;
    }

    public void setExpression(Expression e) {
        this.setParameters((List)Collections.singletonList(e));
    }
}

