/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetIDType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.VersionChangeNative;
import com.supermap.data.VersionChangeType;
import com.supermap.data.VersionChanges;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class VersionChange
extends InternalHandleDisposable {
    protected VersionChanges m_versionChanges = null;
    private DatasetIDType a = DatasetIDType.INT32;

    protected VersionChange(long handle, VersionChanges versionChanges) {
        this.setHandle(handle, true);
        this.m_versionChanges = versionChanges;
        this.a();
    }

    private void a() {
        this.b();
        int n = VersionChangeNative.jni_GetIDType(this.getHandle());
        this.a = (DatasetIDType)Enum.parseUGCValue(DatasetIDType.class, n);
    }

    public Object[] getChangeIDs() {
        this.b();
        int n = VersionChangeNative.jni_GetChangeCount(this.getHandle());
        if (n <= 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        if (this.a == DatasetIDType.INT32) {
            int[] nArray = VersionChangeNative.jni_GetChangeInt32IDs(this.getHandle());
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = nArray[i];
            }
            return objectArray;
        }
        if (this.a == DatasetIDType.INT64) {
            long[] lArray = VersionChangeNative.jni_GetChangeLongIDs(this.getHandle());
            for (int i = 0; i < lArray.length; ++i) {
                objectArray[i] = lArray[i];
            }
            return objectArray;
        }
        return null;
    }

    public VersionChangeType getVersionChangeType(Object id) {
        this.b();
        int n = -1;
        n = this.a == DatasetIDType.INT32 ? VersionChangeNative.jni_GetChangeTypeByInt(this.getHandle(), (Integer)id) : (this.a == DatasetIDType.INT64 ? VersionChangeNative.jni_GetChangeTypeByLong(this.getHandle(), (Long)id) : VersionChangeNative.jni_GetChangeTypeByString(this.getHandle(), (String)id));
        return (VersionChangeType)Enum.parseUGCValue(VersionChangeType.class, n);
    }

    public long getChangeCommonArchiveID(Object id) {
        this.b();
        long l = -1L;
        l = this.a == DatasetIDType.INT32 ? VersionChangeNative.jni_GetChangeCommonArchiveIDByInt(this.getHandle(), (Integer)id) : (this.a == DatasetIDType.INT64 ? VersionChangeNative.jni_GetChangeCommonArchiveIDByLong(this.getHandle(), (Long)id) : VersionChangeNative.jni_GetChangeCommonArchiveIDByString(this.getHandle(), (String)id));
        return l;
    }

    public DatasetVector getDatasetVector() {
        this.b();
        long l = VersionChangeNative.jni_GetDatasetVector(this.getHandle());
        if (l <= 0L) {
            return null;
        }
        if (this.m_versionChanges != null && this.m_versionChanges.m_version != null && this.m_versionChanges.m_version.m_versionManager != null && this.m_versionChanges.m_version.m_versionManager.m_datasource != null) {
            return new DatasetVector(l, this.m_versionChanges.m_version.m_versionManager.m_datasource);
        }
        return null;
    }

    public boolean resetRecordset(Object id) {
        this.b();
        if (this.a == DatasetIDType.INT32) {
            return VersionChangeNative.jni_ResetRecordsetByInt(this.getHandle(), (Integer)id);
        }
        if (this.a == DatasetIDType.INT64) {
            return VersionChangeNative.jni_ResetRecordsetByLong(this.getHandle(), (Long)id);
        }
        return VersionChangeNative.jni_ResetRecordsetByString(this.getHandle(), (String)id);
    }

    public boolean resetRecordsetByTime(Object id, Date resetDate) {
        this.b();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(resetDate);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string = String.format("%d-%d-%d %d:%d:%d", n, n2, n3, n4, n5, n6);
        if (this.a == DatasetIDType.INT32) {
            return VersionChangeNative.jni_ResetRecordsetByTimeByInt(this.getHandle(), (Integer)id, string);
        }
        if (this.a == DatasetIDType.INT64) {
            return VersionChangeNative.jni_ResetRecordsetByTimeByLong(this.getHandle(), (Long)id, string);
        }
        return VersionChangeNative.jni_ResetRecordsetByTimeByString(this.getHandle(), (String)id, string);
    }

    public boolean hasChildVersionChange() {
        this.b();
        return VersionChangeNative.jni_HasChildVersionConflict(this.getHandle());
    }

    public List<VersionChange> getChildVersionChanges() {
        this.b();
        LinkedList<VersionChange> linkedList = new LinkedList<VersionChange>();
        long[] lArray = VersionChangeNative.jni_GetChildVersionChanges(this.getHandle());
        for (int i = 0; i < lArray.length; ++i) {
            linkedList.add(new VersionChange(lArray[i], this.m_versionChanges));
        }
        return linkedList;
    }

    private void b() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
    }

    @Override
    public void dispose() {
        this.dispose(() -> {
            VersionChangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        });
    }
}

