/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolFill3D;
import com.supermap.data.SymbolFill3DBase;
import com.supermap.data.SymbolFillBase;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolLibraryNative;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolLineLibrary;
import com.supermap.data.SymbolMarker;
import com.supermap.data.SymbolMarker3D;
import com.supermap.data.SymbolMarkerLibrary;
import com.supermap.data.SymbolPipeNode;
import java.util.ArrayList;

public abstract class SymbolLibrary
extends InternalHandleDisposable {
    private SymbolGroup a;

    protected SymbolLibrary() {
    }

    public SymbolGroup findGroup(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findGroup(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolGroup symbolGroup = null;
        if (this.getRootGroup() != null) {
            symbolGroup = this.a.b(id);
        }
        return symbolGroup;
    }

    public boolean contains(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("contains(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_Contains(this.getHandle(), id);
    }

    public int getAvailableID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAvailableID(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_GetAvailableID(this.getHandle());
    }

    public Symbol findSymbol(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSymbol(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.a.c(id);
        }
        return symbol;
    }

    public Symbol findSymbol(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findSymbol(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.a.a(name);
        }
        return symbol;
    }

    public boolean toFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toFile(String fileName)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (fileName != null && fileName.trim().length() != 0) {
            if (this instanceof SymbolFillLibrary) {
                if (!fileName.endsWith(".bru")) {
                    fileName = fileName + ".bru";
                }
            } else if (this instanceof SymbolLineLibrary) {
                if (!fileName.endsWith(".lsl")) {
                    fileName = fileName + ".lsl";
                }
            } else if (this instanceof SymbolMarkerLibrary && !fileName.endsWith(".sym")) {
                fileName = fileName + ".sym";
            }
            bl = SymbolLibraryNative.jni_toFile(this.getHandle(), fileName);
        }
        return bl;
    }

    public boolean fromFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromFile(String filename, boolean overWrite)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (fileName != null && fileName.trim().length() != 0) {
            bl = SymbolLibraryNative.jni_fromFile(this.getHandle(), fileName, false);
        }
        if (bl && this.getRootGroup() != null) {
            this.a.reset();
        }
        return bl;
    }

    public boolean remove(int id) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getRootGroup() != null) {
            bl = this.a.a(id);
        }
        return bl;
    }

    public int add(Symbol symbol, SymbolGroup desGroup) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(Symbol symbol, SymbolGroup desGroup)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = InternalResource.loadString("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(symbol);
        if (l == 0L) {
            String string = InternalResource.loadString("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (desGroup == null) {
            String string = InternalResource.loadString("desGroup", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(desGroup);
        if (l2 == 0L) {
            String string = InternalResource.loadString("desGroup", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.a.getChildGroups().contains(desGroup.getName())) {
            String string = InternalResource.loadString("desGroup", "SymbolGroups_NotContainTheSymbolGroup", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.add(symbol);
        if (n != -1) {
            this.moveTo(n, desGroup);
        }
        symbol.makeSureNativeObjectLive();
        desGroup.makeSureNativeObjectLive();
        return n;
    }

    public boolean moveTo(int id, SymbolGroup group) {
        SymbolGroup symbolGroup;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("moveTo(int index, SymbolGroup group)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (group == null) {
            String string = InternalResource.loadString("group", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(group);
        if (l == 0L) {
            String string = InternalResource.loadString("group", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        Symbol symbol = this.findSymbol(id);
        if (symbol != null && (symbolGroup = symbol.getGroup()) != null) {
            int n = symbolGroup.indexOf(id);
            bl = symbolGroup.moveTo(n, group);
        }
        group.makeSureNativeObjectLive();
        return bl;
    }

    public int add(Symbol symbol) {
        long l;
        InternalHandleDisposable internalHandleDisposable;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Add(Symbol symbol)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = InternalResource.loadString("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(symbol);
        if (l2 == 0L) {
            String string = InternalResource.loadString("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolFillLibrary && !(symbol instanceof SymbolFill) && !(symbol instanceof SymbolFill3D)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolLineLibrary && !(symbol instanceof SymbolLine)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolMarkerLibrary && !(symbol instanceof SymbolMarker) && !(symbol instanceof SymbolMarker3D) && !(symbol instanceof SymbolPipeNode)) {
            String string = InternalResource.loadString("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (symbol instanceof SymbolMarker3D) {
            internalHandleDisposable = symbol.getLibrary();
            l = 0L;
            if (internalHandleDisposable != null) {
                l = InternalHandle.getHandle(internalHandleDisposable);
            }
            SymbolLibraryNative.jni_LoadModelInfo(l, l2);
        }
        internalHandleDisposable = null;
        l = 0L;
        if (symbol instanceof SymbolFill3D) {
            long[] lArray = new long[1];
            l = SymbolLibraryNative.jni_addFill3D(this.getHandle(), l2, lArray);
            if (lArray[0] != 0L) {
                internalHandleDisposable = new SymbolFillBase(lArray[0]);
            }
        } else {
            l = SymbolLibraryNative.jni_add(this.getHandle(), l2);
        }
        int n = -1;
        Symbol symbol2 = null;
        if (l != 0L) {
            SymbolFill3D symbolFill3D;
            ArrayList<SymbolFill3DBase> arrayList;
            symbol2 = Symbol.createInstance(l);
            n = symbol2.getID();
            symbol2.setIsDisposable(false);
            if (this.a != null) {
                this.a.a().add(symbol2);
            }
            symbol2.a(this);
            symbol2.setGroup(this.a);
            if (symbol instanceof SymbolFill3D && internalHandleDisposable != null && (arrayList = (symbolFill3D = (SymbolFill3D)symbol).getSymbolFillBases()).size() > 0) {
                arrayList.get(0).a((SymbolFillBase)internalHandleDisposable);
            }
        }
        symbol.makeSureNativeObjectLive();
        return n;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolLibraryNative.jni_clear(this.getHandle());
        if (this.a != null) {
            this.a.reset();
        }
    }

    public SymbolGroup getRootGroup() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRootGroup()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l = SymbolLibraryNative.jni_GetRootGroup(this.getHandle())) != 0L) {
            this.a = new SymbolGroup(this, l);
        }
        return this.a;
    }

    String a() {
        return SymbolLibraryNative.jni_GetLibPath(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }

    public int getMaxID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_getMaxID(this.getHandle());
    }

    protected boolean changeID(int oldID, int newID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("changeID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_changeID(this.getHandle(), oldID, newID);
    }
}

