/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoGraphicCompoundNative;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GraphicCompoundType;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import java.util.ArrayList;

public class GeoGraphicCompound
extends Geometry {
    private ArrayList<Geometry> a;

    public GeoGraphicCompound() {
        long l = GeoGraphicCompoundNative.jni_New();
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    public GeoGraphicCompound(GraphicCompoundType type) {
        long l = GeoGraphicCompoundNative.jni_New1(type.value());
        this.setHandle(l, true);
        this.a = new ArrayList();
    }

    GeoGraphicCompound(long handle) {
        this.setHandle(handle, false);
        this.a = new ArrayList();
        GeoGraphicCompound.a(this);
    }

    public GeoGraphicCompound(GeoGraphicCompound geoGraphicCompound) {
        if (geoGraphicCompound == null) {
            String string = InternalResource.loadString("geoGraphicCompound", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoGraphicCompound);
        if (l == 0L) {
            String string = InternalResource.loadString("geoGraphicCompound", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoGraphicCompoundNative.jni_Clone(l);
        this.a = new ArrayList();
        this.setHandle(l2, true);
        GeoGraphicCompound.a(this);
        InternalHandleDisposable.makeSureNativeObjectLive(geoGraphicCompound);
    }

    public GraphicCompoundType getCompoundType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCompoundType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = GeoGraphicCompoundNative.jni_GetCompoundType(this.getHandle());
        return new GraphicCompoundType(n, n);
    }

    public int addPart(Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddPart(Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = GeoGraphicCompoundNative.jni_addPart(this.getHandle(), geometry2.getHandle());
        int n = -1;
        if (bl) {
            this.a.add(geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
            n = this.a.size() - 1;
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return n;
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoGraphicCompoundNative.jni_getPartCount(this.getHandle());
    }

    public boolean removePart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("RemovePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = false;
        bl = GeoGraphicCompoundNative.jni_removePart(this.getHandle(), index);
        if (bl) {
            this.a.get(index).clearHandle();
            InternalHandleDisposable.setIsDisposable(this.a.get(index), true);
            this.a.remove(index);
        }
        return bl;
    }

    public Geometry getPart(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(index);
    }

    public boolean insertPart(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("InsertPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index > this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoGraphicCompoundNative.jni_insertPart(this.getHandle(), index, geometry2.getHandle());
        if (bl) {
            this.a.add(index, geometry2);
            InternalHandleDisposable.setIsDisposable(geometry2, false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean setPart(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetPart(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (index < 0 || index >= this.a.size()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry2 = geometry.clone();
        boolean bl = false;
        bl = GeoGraphicCompoundNative.jni_setPart(this.getHandle(), index, geometry2.getHandle());
        if (bl) {
            Geometry geometry3 = this.a.get(index);
            geometry3.clearHandle();
            this.a.remove(index);
            this.a.add(index, geometry2);
            geometry2.setIsDisposable(false);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public void adjust(boolean isMinGeometryMovedUp) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Adjust(boolean isMinGeometryMovedUp)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicCompoundNative.jni_adjust(this.getHandle(), isMinGeometryMovedUp);
        int n2 = this.getPartCount();
        long[] lArray = new long[n2];
        GeoGraphicCompoundNative.jni_AllSubGeometrys(this.getHandle(), lArray);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (n = 0; n < this.a.size(); ++n) {
            arrayList.add(this.a.get(n));
        }
        this.a.clear();
        block1: for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (((Geometry)arrayList.get(i)).getHandle() != lArray[n]) continue;
                this.a.add((Geometry)arrayList.get(i));
                arrayList.remove(i);
                continue block1;
            }
        }
    }

    public Geometry[] divide(boolean isTopOnly) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Divide(boolean isTopOnly)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = GeoGraphicCompoundNative.jni_divide(this.getHandle(), isTopOnly);
        int n = lArray.length;
        Geometry[] geometryArray = new Geometry[n];
        for (int i = 0; i < n; ++i) {
            geometryArray[i] = Geometry.createInstance(lArray[i]);
        }
        return geometryArray;
    }

    @Override
    public GeoGraphicCompound clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoGraphicCompound(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoGraphicCompoundNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    @Override
    public void setEmpty() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicCompoundNative.jni_Clear(this.getHandle());
        for (int i = 0; i < this.a.size(); ++i) {
            this.a.get(i).setIsDisposable(true);
            this.a.get(i).setHandle(0L);
            this.a.get(i).clearHandle();
        }
        this.a.clear();
    }

    public String getUuID() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUuID()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = GeoGraphicCompoundNative.jni_GetUuID(this.getHandle());
        return string;
    }

    public void generateUuid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("generateUuid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoGraphicCompoundNative.jni_GenerateUuID(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        for (int i = 0; i < this.a.size(); ++i) {
            this.a.get(i).setIsDisposable(true);
            this.a.get(i).setHandle(0L);
            this.a.get(i).clearHandle();
        }
        this.a.clear();
    }

    static void a(GeoGraphicCompound geoGraphicCompound) {
        int n = geoGraphicCompound.getPartCount();
        long[] lArray = new long[n];
        GeoGraphicCompoundNative.jni_AllSubGeometrys(geoGraphicCompound.getHandle(), lArray);
        for (int i = 0; i < lArray.length; ++i) {
            Geometry geometry = Geometry.createInstance(lArray[i]);
            geometry.setIsDisposable(false);
            geoGraphicCompound.a.add(geometry);
        }
        InternalHandleDisposable.makeSureNativeObjectLive(geoGraphicCompound);
    }

    void a() {
        for (int i = 0; i < this.a.size(); ++i) {
            Geometry geometry;
            if (this.a.get(i) instanceof GeoRegion) {
                geometry = (GeoRegion)this.a.get(i);
                ((GeoRegion)geometry).b();
            }
            if (!(this.a.get(i) instanceof GeoLine)) continue;
            geometry = (GeoLine)this.a.get(i);
            ((GeoLine)geometry).b();
        }
    }

    protected static GeoGraphicCompound creatInstance(long handle) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoGraphicCompound(handle);
    }
}

