/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoEntityNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;

public class GeoEntity
extends Geometry {
    public GeoEntity() {
        long l = GeoEntityNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoEntity(GeoEntity geoEntity) {
        if (geoEntity == null) {
            String string = InternalResource.loadString("geoEntity", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoEntity);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoEntity", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoEntityNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoEntity);
    }

    GeoEntity(long handle) {
        this.setHandle(handle, false);
    }

    public boolean addPrimitive(String dtName, String elemID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPrimitive", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEntityNative.jni_AddPrimitive(this.getHandle(), dtName, elemID);
    }

    public boolean deletePrimitive(String dtName, String elemID) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("deletePrimitive", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEntityNative.jni_DeletePrimitive(this.getHandle(), dtName, elemID);
    }

    public boolean fromJson(String json) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromJson", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEntityNative.jni_FromJson(this.getHandle(), json);
    }

    public String toJson() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toJson", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEntityNative.jni_ToJson(this.getHandle());
    }

    @Override
    public GeoEntity clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEntity(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEntityNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

