/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Enum;
import com.supermap.data.GeoBillboardNative;
import com.supermap.data.GeoBillboardQuality;
import com.supermap.data.Geometry;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalResource;

public class GeoBillboard
extends Geometry3D {
    public GeoBillboard() {
        this.setHandle(GeoBillboardNative.jni_New(), true);
    }

    public GeoBillboard(GeoBillboard geoBillboard) {
        if (geoBillboard == null) {
            String string = InternalResource.loadString("geoBillboard", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoBillboard);
        if (l == 0L) {
            String string = InternalResource.loadString("geoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoBillboardNative.jni_Clone(l);
        super.setHandle(l2, true);
    }

    GeoBillboard(long handle) {
        this.setHandle(handle, false);
    }

    @Override
    public Geometry clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoBillboard(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.clearHandle();
        }
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(double width) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBillboardNative.jni_SetWidth(this.getHandle(), width);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double height) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBillboardNative.jni_SetHeight(this.getHandle(), height);
    }

    public GeoBillboardQuality getQuality() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = GeoBillboardNative.jni_GetQuality(this.getHandle());
        return (GeoBillboardQuality)Enum.parseUGCValue(GeoBillboardQuality.class, n);
    }

    public void setQuality(GeoBillboardQuality quality) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoBillboardNative.jni_SetQuality(this.getHandle(), quality.value());
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_GetCount(this.getHandle());
    }

    public int add(Geometry geometry, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = geometry.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_Add(this.getHandle(), l, tag);
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_Remove(this.getHandle(), index);
    }

    public Geometry get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = GeoBillboardNative.jni_Get(this.getHandle(), index);
        return Geometry.internalCreateInstance(l);
    }

    public boolean set(int index, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = geometry.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_Set(this.getHandle(), index, l);
    }

    public String getTag(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_GetTag(this.getHandle(), index);
    }

    public boolean setTag(int index, String tag) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GeoBillboard", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeoBillboardNative.jni_SetTag(this.getHandle(), index, tag);
    }
}

