/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Colors;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetMosaicNative;
import com.supermap.data.DatasetNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MosaicColorBalanceMethod;
import com.supermap.data.MosaicProgress;
import com.supermap.data.MosaicSteppedEvent;
import com.supermap.data.MosaicSteppedListener;
import com.supermap.data.PixelFormat;
import com.supermap.data.PyramidResampleType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.StatisticsResult;
import com.supermap.data.TiffCompressType;
import com.supermap.data.Toolkit;
import com.supermap.data.b;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class DatasetMosaic
extends Dataset {
    private Colors e;
    private DatasetVector f;
    private DatasetVector g;
    private DatasetVector h;
    protected static CopyOnWriteArrayList<MosaicSteppedListener> m_mosaicsteppedListeners;

    protected DatasetMosaic() {
    }

    DatasetMosaic(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
        this.m_datasource = datasource;
        this.m_ugcRawPointerHandle = DatasetNative.jni_GetRawPointerHandle(handle);
    }

    @Override
    protected void clearHandle() {
        if (this.f != null) {
            this.f.clearHandle();
            this.f = null;
        }
        if (this.e != null) {
            this.e.clearHandle();
            this.e = null;
        }
        if (this.g != null) {
            this.g.clearHandle();
            this.g = null;
        }
        if (this.h != null) {
            this.h.clearHandle();
            this.h = null;
        }
        this.setHandle(0L);
    }

    public synchronized void addMosaicSteppedListener(MosaicSteppedListener l) {
        if (m_mosaicsteppedListeners == null) {
            m_mosaicsteppedListeners = new CopyOnWriteArrayList();
        }
        if (!m_mosaicsteppedListeners.contains(l)) {
            m_mosaicsteppedListeners.add(l);
        }
    }

    public synchronized void removeMosaicSteppedListener(MosaicSteppedListener l) {
        if (m_mosaicsteppedListeners != null && m_mosaicsteppedListeners.contains(l)) {
            m_mosaicsteppedListeners.remove(l);
        }
    }

    protected static void fireStepped(MosaicSteppedEvent event) {
        if (m_mosaicsteppedListeners != null) {
            CopyOnWriteArrayList<MosaicSteppedListener> copyOnWriteArrayList = m_mosaicsteppedListeners;
            for (MosaicSteppedListener mosaicSteppedListener : copyOnWriteArrayList) {
                mosaicSteppedListener.mosaicStepped(event);
            }
        }
    }

    static void mosaicSteppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        Object object = new Object();
        boolean bl = Toolkit.getHandleBooleanValue(cancelHandle);
        MosaicSteppedEvent mosaicSteppedEvent = new MosaicSteppedEvent(object, title, message, percent, bl, remainTime);
        DatasetMosaic.fireStepped(mosaicSteppedEvent);
        Toolkit.setHandleBooleanValue(cancelHandle, mosaicSteppedEvent.getCancel());
        mosaicSteppedEvent = null;
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetHeight(this.getHandle());
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBandCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetBandCount(this.getHandle());
    }

    public void setBandCount(int bandCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBandCount(bandCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetMosaicNative.jni_SetBandCount(this.getHandle(), bandCount);
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPixelFormat()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetMosaicNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPixelFormat(pixelFormat)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetMosaicNative.jni_SetPixelFormat(this.getHandle(), pixelFormat.getUGCValue());
    }

    public String getBandName(int bandIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBandAlias(bandIndex)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetBandName(this.getHandle(), bandIndex);
    }

    public boolean setBandName(int bandIndex, String bandName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBandAlias(bandIndex,bandAlias)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_SetBandName(this.getHandle(), bandIndex, bandName);
    }

    public DatasetVector getFootprintDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFootprintDataset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.f == null) {
            long l = DatasetMosaicNative.jni_GetFootprintDataset(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.f = new DatasetVector(l, this.getDatasource());
        }
        return this.f;
    }

    public DatasetVector getBoundaryDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBoundaryDataset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.g == null) {
            long l = DatasetMosaicNative.jni_GetBoundaryDataset(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.g = new DatasetVector(l, this.getDatasource());
        }
        return this.g;
    }

    public DatasetVector getClipDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipDataset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.h == null) {
            long l = DatasetMosaicNative.jni_GetClipDataset(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.h = new DatasetVector(l, this.getDatasource());
        }
        return this.h;
    }

    @Deprecated
    public boolean addFiles(String directoryPath, String extension, String clipFileExtension) {
        Object object;
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addFiles()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (directoryPath == null || directoryPath.trim().length() == 0) {
            String string = InternalResource.loadString("directoryPath", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (extension == null || directoryPath.trim().length() == 0) {
            String string = InternalResource.loadString("extension", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipFileExtension == null) {
            clipFileExtension = "";
        }
        if (!directoryPath.endsWith("/") && !directoryPath.endsWith("\\")) {
            directoryPath = directoryPath.indexOf(47) >= 0 ? directoryPath + "/" : directoryPath + "\\";
        }
        if ((n = extension.indexOf(46)) >= 0) {
            extension = extension.substring(n);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File file = new File(directoryPath);
        if (file.isDirectory()) {
            object = null;
            for (File file2 : file.listFiles()) {
                object = file2.getName();
                if (!((String)object).endsWith(extension)) continue;
                object = directoryPath + (String)object;
                arrayList.add(object);
            }
        }
        if (arrayList.size() < 1) {
            object = InternalResource.loadString("extension", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        int n2 = DatasetMosaicNative.jni_AddFiles1(this.getHandle(), (String[])object, clipFileExtension);
        return n2 == 0;
    }

    public boolean addFiles(String[] directoryPaths, String clipFileExtension) {
        return this.addFiles(directoryPaths, clipFileExtension, "", null, null);
    }

    @Deprecated
    public boolean addFiles(String[] directoryPaths, String clipFileExtension, Map<String, Map<String, String>> fieldValues) {
        return this.addFiles(directoryPaths, clipFileExtension, fieldValues, null);
    }

    @Deprecated
    public boolean addFiles(String[] directoryPaths, String clipFileExtension, Map<String, Map<String, String>> fieldValues, MosaicSteppedListener listener) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("noReturn");
        boolean bl = this.a(directoryPaths, clipFileExtension, stringBuilder, fieldValues, listener);
        return bl;
    }

    public boolean addFiles(String[] directoryPaths, String clipFileExtension, String rasterType, Map<String, String> rasterParameter, MosaicSteppedListener listener) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("noReturn");
        boolean bl = this.a(directoryPaths, clipFileExtension, rasterType, rasterParameter, stringBuilder, listener);
        return bl;
    }

    public String addFilesWithReport(String[] directoryPaths, String clipFileExtension) {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(directoryPaths, clipFileExtension, stringBuilder, null, null);
        return stringBuilder.toString();
    }

    @Deprecated
    public String addFilesWithReport(String[] directoryPaths, String clipFileExtension, Map<String, Map<String, String>> fieldValues) {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(directoryPaths, clipFileExtension, stringBuilder, fieldValues, null);
        return stringBuilder.toString();
    }

    @Deprecated
    public boolean addFilesWithReport(String[] directoryPaths, String clipFileExtension, Map<String, Map<String, String>> fieldValues, StringBuilder resultJson) {
        boolean bl = this.a(directoryPaths, clipFileExtension, resultJson, fieldValues, null);
        return bl;
    }

    @Deprecated
    public boolean addFilesWithReport(String[] directoryPaths, String clipFileExtension, Map<String, Map<String, String>> fieldValues, StringBuilder resultJson, MosaicSteppedListener listener) {
        boolean bl = this.a(directoryPaths, clipFileExtension, resultJson, fieldValues, listener);
        return bl;
    }

    public boolean addFilesWithReport(String[] directoryPaths, String clipFileExtension, String rasterType, Map<String, String> rasterParameter, StringBuilder resultJson, MosaicSteppedListener listener) {
        boolean bl = this.a(directoryPaths, clipFileExtension, rasterType, rasterParameter, resultJson, listener);
        return bl;
    }

    private boolean a(String[] stringArray, String string2, String string3, Map<String, String> map, StringBuilder stringBuilder, MosaicSteppedListener mosaicSteppedListener) {
        if (this.getHandle() == 0L) {
            String string4 = InternalResource.loadString("addFiles()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string4);
        }
        int n = stringArray.length;
        if (n < 1) {
            String string5 = InternalResource.loadString("extension", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (mosaicSteppedListener != null) {
            mosaicProgress.a(mosaicSteppedListener);
        }
        if (m_mosaicsteppedListeners != null && m_mosaicsteppedListeners.size() > 0) {
            m_mosaicsteppedListeners.stream().forEach(mosaicProgress::a);
        }
        String string6 = "";
        if (map != null && map.size() != 0) {
            string6 = map.keySet().stream().map(string -> String.format("\"%s\":\"%s\"", string, map.get(string))).collect(Collectors.joining(","));
            string6 = String.format("{%s}", string6);
        }
        String[] stringArray2 = new String[]{stringBuilder.toString()};
        int n2 = DatasetMosaicNative.jni_AddFilesWithReport(this.getHandle(), stringArray, string2, string3, string6, stringArray2, mosaicProgress.getHandle());
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append(stringArray2[0]);
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return n2 == 0;
    }

    private boolean a(String[] stringArray, String string, StringBuilder stringBuilder, Map<String, Map<String, String>> map, MosaicSteppedListener mosaicSteppedListener) {
        boolean bl = this.a(stringArray, string, "", null, stringBuilder, mosaicSteppedListener);
        if (bl && map != null && !map.isEmpty()) {
            FieldInfos fieldInfos = this.getFootprintDataset().getFieldInfos();
            Recordset recordset = this.getFootprintDataset().getRecordset(false, CursorType.DYNAMIC);
            recordset.moveFirst();
            while (!recordset.isEOF()) {
                String string2 = (String)recordset.getFieldValue("SmPath");
                if (map.containsKey(string2)) {
                    Map<String, String> map2 = map.get(string2);
                    for (String string3 : map2.keySet()) {
                        int n = fieldInfos.indexOf(string3);
                        if (n < 0) continue;
                        recordset.edit();
                        if (fieldInfos.get(n).getType() == FieldType.DATETIME) {
                            String string4 = map2.get(string3);
                            Date date = com.supermap.data.b.a(string4);
                            if (date != null) {
                                recordset.setFieldValue(n, (Object)date);
                            }
                        } else {
                            recordset.setFieldValue(n, (Object)map2.get(string3));
                        }
                        recordset.update();
                    }
                }
                recordset.moveNext();
            }
            recordset.dispose();
        }
        return bl;
    }

    public boolean overviewPreprocess(boolean reloadFile, double[] outputResolution, StringBuilder stringBuilder, MosaicSteppedListener listener) {
        if (outputResolution == null || outputResolution.length == 0) {
            String string = InternalResource.loadString("outputResolution", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        String[] stringArray = new String[]{stringBuilder.toString()};
        long l = DatasetMosaicNative.jni_OverviewPreprocess(this.getHandle(), reloadFile, outputResolution, stringArray, mosaicProgress.getHandle());
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append(stringArray[0]);
        return l == 0L;
    }

    public boolean buildOverview(String path, int maxWidth, int maxHeight, int ratio, Boolean hasNoValue, Double noValue) {
        return this.buildOverview(path, maxWidth, maxHeight, ratio, hasNoValue, noValue, null);
    }

    public boolean buildOverview(String path, int maxWidth, int maxHeight, int ratio, Boolean hasNoValue, Double noValue, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.isEmpty()) {
            String string = InternalResource.loadString("path", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxWidth <= 0) {
            String string = InternalResource.loadString("maxWidth", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxHeight <= 0) {
            String string = InternalResource.loadString("maxHeight", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (ratio <= 0) {
            String string = InternalResource.loadString("ratio", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        int n = DatasetMosaicNative.jni_BuildOverview(this.getHandle(), path, maxWidth, maxHeight, ratio, hasNoValue, noValue, mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return n == 0;
    }

    public boolean buildStatistics() {
        return this.buildStatistics(null);
    }

    public boolean buildStatistics(MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildStatistics()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        int n = DatasetMosaicNative.jni_BuildStatistics(this.getHandle(), mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return n == 0;
    }

    public HashMap<Integer, StatisticsResult> getStatistics() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStatistics()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getBandCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        if (DatasetMosaicNative.jni_getStatistics(this.getHandle(), nArray, lArray)) {
            HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
            for (int i = 0; i < n; ++i) {
                StatisticsResult statisticsResult = new StatisticsResult(lArray[i]);
                hashMap.put(nArray[i], statisticsResult);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(hashMap);
            return hashMap;
        }
        return null;
    }

    public boolean buildHistograms(boolean isRebuild) {
        return this.buildHistograms(isRebuild, null);
    }

    public boolean buildHistograms(boolean isRebuild, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildHistograms()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        boolean bl = DatasetMosaicNative.jni_BuildHistograms(this.getHandle(), isRebuild, mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return bl;
    }

    public boolean buildPyramid(PyramidResampleType type, Boolean skipExists) {
        return this.buildPyramid(type, TiffCompressType.LZW, skipExists);
    }

    public boolean buildPyramid(PyramidResampleType type, TiffCompressType compressType, Boolean skipExists) {
        return this.buildPyramid(type, compressType, skipExists, null);
    }

    public boolean buildPyramid(PyramidResampleType type, TiffCompressType compressType, Boolean skipExists, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildPyramid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (compressType == null) {
            String string = InternalResource.loadString("compressType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        boolean bl = DatasetMosaicNative.jni_BuildPyramid(this.getHandle(), type.getUGCValue(), compressType.getUGCValue(), skipExists, mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return bl;
    }

    public boolean removePyramid() {
        return this.removePyramid(null);
    }

    public boolean removePyramid(MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePyramid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        boolean bl = DatasetMosaicNative.jni_RemovePyramid(this.getHandle(), mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return bl;
    }

    public int clear() {
        return this.clear(null);
    }

    public int clear(MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        int n = DatasetMosaicNative.jni_Clear(this.getHandle(), mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return n;
    }

    public int removeOverview() {
        return this.removeOverview(null);
    }

    public int removeOverview(MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        int n = DatasetMosaicNative.jni_RemoveOverview(this.getHandle(), mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return n;
    }

    public int rebuild(boolean isRebuildFootprint, boolean isRebuildBoundary, GeoRegion exRegion, boolean isRebuildClip, String postfix, boolean isAutoContour, boolean isExactClip, boolean isComplexShape, int tolerance, int clipPixelLength) {
        return this.rebuild(isRebuildFootprint, isRebuildBoundary, exRegion, isRebuildClip, postfix, isAutoContour, isExactClip, isComplexShape, tolerance, clipPixelLength, null);
    }

    public int rebuild(boolean isRebuildFootprint, boolean isRebuildBoundary, GeoRegion exRegion, boolean isRebuildClip, String postfix, boolean isAutoContour, boolean isExactClip, boolean isComplexShape, int tolerance, int clipPixelLength, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rebuild", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0) {
            String string = InternalResource.loadString("tolerance", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipPixelLength < 0) {
            String string = InternalResource.loadString("clipPixelLength", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (exRegion != null) {
            l = DatasetMosaic.getHandle(exRegion);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        int n = DatasetMosaicNative.jni_Rebuild(this.getHandle(), isRebuildFootprint, isRebuildBoundary, l, isRebuildClip, postfix, isAutoContour, isExactClip, isComplexShape, tolerance, clipPixelLength, mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return n;
    }

    @Deprecated
    public int rebuild(boolean isRebuildFootprint, boolean isRebuildBoundary, GeoRegion exRegion, boolean isRebuildClip, String postfix, boolean isAutoContour, boolean isExactClip) {
        return this.rebuild(isRebuildFootprint, isRebuildBoundary, exRegion, isRebuildClip, postfix, false, false, false, 0, 0);
    }

    @Deprecated
    public int rebuild(boolean isRebuildFootprint, boolean isRebuildBoundary, GeoRegion exRegion, boolean isRebuildClip, String postfix) {
        return this.rebuild(isRebuildFootprint, isRebuildBoundary, exRegion, isRebuildClip, postfix, false, false);
    }

    public boolean append(DatasetMosaic datasetMosaic, String sql, boolean appendOverview, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("append()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (datasetMosaic == null) {
            String string = InternalResource.loadString("datasetMosaic", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetMosaic.getHandle() == 0L) {
            String string = InternalResource.loadString("datasetMosaic", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        boolean bl = DatasetMosaicNative.jni_Append(this.getHandle(), datasetMosaic.getHandle(), sql, appendOverview, mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return bl;
    }

    public boolean append(DatasetMosaic datasetMosaic, String sql, boolean appendOverview) {
        return this.append(datasetMosaic, sql, appendOverview, null);
    }

    public boolean colorBalance(String standardImageFile, MosaicColorBalanceMethod method, double varianceRatio, double brightnessRatio) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("colorBalance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (method == MosaicColorBalanceMethod.HISTOGRAM_SPECIFICATION && (standardImageFile == null || standardImageFile.isEmpty())) {
            String string = InternalResource.loadString("standardImageFile", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (varianceRatio < 0.0) {
            varianceRatio = 0.0;
        } else if (varianceRatio > 1.0) {
            varianceRatio = 1.0;
        }
        if (brightnessRatio < 0.0) {
            brightnessRatio = 0.0;
        } else if (brightnessRatio > 1.0) {
            brightnessRatio = 1.0;
        }
        return DatasetMosaicNative.jni_ColorBalance(this.getHandle(), method.getUGCValue(), standardImageFile, varianceRatio, brightnessRatio);
    }

    public boolean cleanColorBalance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("colorBalance()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_CleanColorBalance(this.getHandle());
    }

    @Deprecated
    public String getSatelliteType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSatelliteType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetSatelliteType(this.getHandle());
    }

    public String getProductName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProductName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetSatelliteType(this.getHandle());
    }

    public void setProductName(String productName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProductName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetMosaicNative.jni_SetProductName(this.getHandle(), productName);
    }

    public boolean createThumbnail() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("createThumbnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.createThumbnail(null, 512);
    }

    public boolean createThumbnail(int[] ids, int minEdgeLength) {
        return this.createThumbnail(ids, minEdgeLength, null);
    }

    public boolean createThumbnail(int[] ids, int minEdgeLength, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("createThumbnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (minEdgeLength <= 0) {
            String string = InternalResource.loadString("minEdgeLength", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (ids == null) {
            ids = new int[]{};
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        boolean bl = DatasetMosaicNative.jni_CreateThumbnail(this.getHandle(), ids, minEdgeLength, mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return bl;
    }

    @Deprecated
    public byte[] createThumbnail(String filePath, int id, int minEdgeLength) {
        return this.createThumbnail(filePath, id, minEdgeLength, null);
    }

    public byte[] createThumbnail(int id, int minEdgeLength, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("createThumbnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (minEdgeLength <= 0) {
            String string = InternalResource.loadString("minEdgeLength", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        byte[] byArray = DatasetMosaicNative.jni_CreateSingleThumbnail(this.getHandle(), id, minEdgeLength, mosaicProgress.getHandle());
        InternalHandleDisposable.makeSureNativeObjectLive(mosaicProgress);
        return byArray;
    }

    public byte[] createThumbnail(int id, int minEdgeLength) {
        return this.createThumbnail(id, minEdgeLength, null);
    }

    @Deprecated
    public byte[] createThumbnail(String filePath, int id, int minEdgeLength, MosaicSteppedListener listener) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("createThumbnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (minEdgeLength <= 0) {
            String string = InternalResource.loadString("minEdgeLength", "Must_Larger_Than_Zero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        MosaicProgress mosaicProgress = new MosaicProgress();
        if (listener != null) {
            mosaicProgress.a(listener);
        }
        return this.createThumbnail(id, minEdgeLength, listener);
    }

    public boolean clearThumbnail() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearThumbnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.clearThumbnail(null);
    }

    public boolean clearThumbnail(int[] ids) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearThumbnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (ids == null) {
            ids = new int[]{};
        }
        return DatasetMosaicNative.jni_ClearThumbnail(this.getHandle(), ids);
    }

    public Map<String, String> getExtendAttributes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearThumbnail()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetMosaicNative.jni_GetExtendAttributesLength(this.getHandle());
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        if (DatasetMosaicNative.jni_GetExtendAttributes(this.getHandle(), stringArray, stringArray2)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < n; ++i) {
                hashMap.put(stringArray[i], stringArray2[i]);
            }
            return hashMap;
        }
        return null;
    }

    public byte[] buildVRT(Rectangle2D bounds, double nodata) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildMask()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (null == bounds) {
            String string = InternalResource.loadString("bounds", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = bounds.getLeft();
        double d3 = bounds.getBottom();
        double d4 = bounds.getRight();
        double d5 = bounds.getTop();
        return DatasetMosaicNative.jni_BuildVRT(this.getHandle(), d2, d3, d4, d5, nodata);
    }
}

