/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.BoundingBox;
import com.supermap.data.CSGBooleanNode;
import com.supermap.data.CSGEntityNative;
import com.supermap.data.CSGEntityType;
import com.supermap.data.CSGNode;
import com.supermap.data.CSGSimpleNode;
import com.supermap.data.Environment;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Matrix;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class CSGEntity
extends InternalHandleDisposable {
    protected CSGEntityType m_entityType;

    protected CSGEntity() {
    }

    protected CSGEntity(CSGEntity csgEntity) {
    }

    public BoundingBox getBoundingBox() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBoundingBox", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[6];
        CSGEntityNative.jni_GetBoundingBox(this.getHandle(), dArray);
        Point3D point3D = new Point3D(dArray[0], dArray[1], dArray[2]);
        Point3D point3D2 = new Point3D(dArray[3], dArray[4], dArray[5]);
        BoundingBox boundingBox = new BoundingBox(point3D, point3D2);
        return boundingBox;
    }

    public CSGEntityType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCsgEntityType", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = CSGEntityNative.jni_GetCsgEntityType(this.getHandle());
        return new CSGEntityType(n, n);
    }

    protected static void clearHandle(CSGEntity csgEntity) {
        csgEntity.clearHandle();
    }

    public CSGBooleanNode union(CSGNode rightNode) {
        if (rightNode == null) {
            return null;
        }
        long l = CSGEntity.getHandle(rightNode);
        long l2 = CSGEntityNative.jni_OperationUnion(this.getHandle(), l);
        return new CSGBooleanNode(l2);
    }

    public CSGBooleanNode union(CSGEntity csgEntity) {
        if (csgEntity == null) {
            return null;
        }
        long l = CSGEntity.getHandle(csgEntity);
        long l2 = CSGEntityNative.jni_OperationUnion1(this.getHandle(), l);
        return new CSGBooleanNode(l2);
    }

    public CSGBooleanNode intersect(CSGNode rightNode) {
        if (rightNode == null) {
            return null;
        }
        long l = CSGEntity.getHandle(rightNode);
        long l2 = CSGEntityNative.jni_OperationIntersect(this.getHandle(), l);
        return new CSGBooleanNode(l2);
    }

    public CSGBooleanNode intersect(CSGEntity csgEntity) {
        if (csgEntity == null) {
            return null;
        }
        long l = CSGEntity.getHandle(csgEntity);
        long l2 = CSGEntityNative.jni_OperationIntersect1(this.getHandle(), l);
        return new CSGBooleanNode(l2);
    }

    public CSGBooleanNode difference(CSGNode csgNode) {
        if (csgNode == null) {
            return null;
        }
        long l = CSGEntity.getHandle(csgNode);
        long l2 = CSGEntityNative.jni_OperationDifference(this.getHandle(), l);
        return new CSGBooleanNode(l2);
    }

    public CSGBooleanNode difference(CSGEntity csgEntity) {
        if (csgEntity == null) {
            return null;
        }
        long l = CSGEntity.getHandle(csgEntity);
        long l2 = CSGEntityNative.jni_OperationDifference1(this.getHandle(), l);
        return new CSGBooleanNode(l2);
    }

    public CSGSimpleNode multiply(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        long l = CSGEntity.getHandle(matrix);
        long l2 = CSGEntityNative.jni_Multiply(this.getHandle(), l);
        return new CSGSimpleNode(l2);
    }

    public CSGSimpleNode translate(Point3D translate) {
        if (translate == null) {
            return null;
        }
        long l = CSGEntityNative.jni_Translate(this.getHandle(), translate.getX(), translate.getY(), translate.getZ());
        return new CSGSimpleNode(l);
    }

    public CSGSimpleNode scale(Point3D scale) {
        if (scale == null) {
            return null;
        }
        long l = CSGEntityNative.jni_Scale(this.getHandle(), scale.getX(), scale.getY(), scale.getZ());
        return new CSGSimpleNode(l);
    }

    public CSGSimpleNode rotate(Point3D rotate) {
        if (rotate == null) {
            return null;
        }
        long l = CSGEntityNative.jni_Rotate(this.getHandle(), rotate.getX(), rotate.getY(), rotate.getZ());
        return new CSGSimpleNode(l);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getArea", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = CSGEntityNative.jni_GetArea3D(this.getHandle());
        return d2;
    }

    public double getVolume() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVolume", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = CSGEntityNative.jni_GetVolume(this.getHandle());
        return d2;
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CSGEntityNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public CSGEntity clone() {
        if (this == null) {
            String string = InternalResource.loadString("clone", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = CSGEntityNative.jni_Clone(this.getHandle());
        CSGEntity cSGEntity = null;
        if (l != 0L) {
            cSGEntity = CSGEntity.createInstance(l);
            InternalHandleDisposable.setIsDisposable(cSGEntity, false);
        }
        return cSGEntity;
    }

    protected static CSGEntity createInstance(long handle) {
        CSGEntity cSGEntity = null;
        try {
            URLClassLoader uRLClassLoader = CSGEntity.a();
            if (uRLClassLoader != null) {
                Object object;
                String string = "com.supermap.realspace.threeddesigner.InternalCSGEntity";
                String string2 = "createInstance";
                Class<?> clazz = uRLClassLoader.loadClass(string);
                Method[] methodArray = clazz.getMethods();
                Method method = null;
                for (int i = 0; i < methodArray.length; ++i) {
                    Method method2 = methodArray[i];
                    if (!method2.getName().contains(string2)) continue;
                    method = method2;
                    break;
                }
                if (method != null && (cSGEntity = (CSGEntity)(object = method.invoke(null, handle))) != null) {
                    cSGEntity.setIsDisposable(true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cSGEntity;
    }

    private static URLClassLoader a() {
        try {
            String string = Environment.getUGOBasePath();
            String string2 = string + "./com.supermap.realspace.threeddesigner.jar";
            URL uRL = new URL("file:" + string2);
            URL[] uRLArray = new URL[]{uRL};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            return uRLClassLoader;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected double[] convertToDoubleArray(Point2Ds point2Ds) {
        Point2D[] point2DArray = point2Ds.toArray();
        double[] dArray = new double[point2DArray.length * 2];
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            dArray[i * 2] = point2D.getX();
            dArray[i * 2 + 1] = point2D.getY();
        }
        return dArray;
    }

    protected double[] convertToDoubleArray(Point3Ds point3Ds) {
        Point3D[] point3DArray = point3Ds.toArray();
        double[] dArray = new double[point3DArray.length * 3];
        for (int i = 0; i < point3DArray.length; ++i) {
            Point3D point3D = point3DArray[i];
            dArray[i * 3] = point3D.getX();
            dArray[i * 3 + 1] = point3D.getY();
            dArray[i * 3 + 2] = point3D.getZ();
        }
        return dArray;
    }

    protected Point2Ds convertToPoint2Ds(double[] pointArray) {
        Point2Ds point2Ds = new Point2Ds();
        for (int i = 0; i < pointArray.length / 2; ++i) {
            Point2D point2D = new Point2D();
            point2D.setX(pointArray[i * 2]);
            point2D.setY(pointArray[i * 2 + 1]);
            point2Ds.add(point2D);
        }
        return point2Ds;
    }

    protected Point3Ds convertToPoint3Ds(double[] pointArray) {
        Point3Ds point3Ds = new Point3Ds();
        for (int i = 0; i < pointArray.length / 3; ++i) {
            Point3D point3D = new Point3D();
            point3D.setX(pointArray[i * 3]);
            point3D.setY(pointArray[i * 3 + 1]);
            point3D.setZ(pointArray[i * 3 + 2]);
            point3Ds.add(point3D);
        }
        return point3Ds;
    }
}

